"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.TransactionDurationSummary = TransactionDurationSummary;
var _react = _interopRequireDefault(require("react"));
var _eui = require("@elastic/eui");
var _i18n = require("@kbn/i18n");
var _apmUiShared = require("@kbn/apm-ui-shared");
var _apmTypesShared = require("@kbn/apm-types-shared");
var _use_root_transaction = require("../../hooks/use_root_transaction");
var _use_transaction_latency_chart = require("../../hooks/use_transaction_latency_chart");
var _section = require("../../../components/section");
var _field_without_actions = require("../../../components/field_without_actions");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the "Elastic License
 * 2.0", the "GNU Affero General Public License v3.0 only", and the "Server Side
 * Public License v 1"; you may not use this file except in compliance with, at
 * your election, the "Elastic License 2.0", the "GNU Affero General Public
 * License v3.0 only", or the "Server Side Public License, v 1".
 */

function TransactionDurationSummary({
  transactionDuration,
  transactionName,
  transactionType,
  serviceName
}) {
  var _latencyChartData$tra, _latencyChartData$per;
  const {
    transaction: rootTransaction,
    loading: rootTransactionLoading
  } = (0, _use_root_transaction.useRootTransactionContext)();
  const {
    data: latencyChartData,
    loading: latencyChartLoading,
    hasError: latencyChartHasError
  } = (0, _use_transaction_latency_chart.useTransactionLatencyChart)({
    transactionName,
    transactionType,
    serviceName
  });
  return /*#__PURE__*/_react.default.createElement(_section.Section, {
    title: _i18n.i18n.translate('unifiedDocViewer.observability.traces.docViewerTransactionOverview.spanDurationSummary.title', {
      defaultMessage: 'Duration'
    }),
    subtitle: _i18n.i18n.translate('unifiedDocViewer.observability.traces.docViewerTransactionOverview.spanDurationSummary.description', {
      defaultMessage: 'Time taken to complete this transaction from start to finish.'
    })
  }, /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, /*#__PURE__*/_react.default.createElement(_field_without_actions.FieldWithoutActions, {
    label: _i18n.i18n.translate('unifiedDocViewer.observability.traces.docViewerTransactionOverview.spanDurationSummary.duration.title', {
      defaultMessage: 'Duration'
    })
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiText, {
    size: "xs"
  }, /*#__PURE__*/_react.default.createElement(_apmUiShared.Duration, {
    duration: transactionDuration,
    parent: {
      type: 'trace',
      duration: rootTransaction === null || rootTransaction === void 0 ? void 0 : rootTransaction.duration,
      loading: rootTransactionLoading
    }
  }))), /*#__PURE__*/_react.default.createElement(_eui.EuiHorizontalRule, {
    margin: "xs"
  }), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, null, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, null, /*#__PURE__*/_react.default.createElement(_eui.EuiTitle, {
    size: "xxxs"
  }, /*#__PURE__*/_react.default.createElement("h3", null, _i18n.i18n.translate('unifiedDocViewer.observability.traces.docViewerTransactionOverview.spanDurationSummary.latency.title', {
    defaultMessage: 'Latency'
  }))), (latencyChartLoading || latencyChartData) && /*#__PURE__*/_react.default.createElement(_apmUiShared.DurationDistributionChart, {
    data: (_latencyChartData$tra = latencyChartData === null || latencyChartData === void 0 ? void 0 : latencyChartData.transactionDistributionChartData) !== null && _latencyChartData$tra !== void 0 ? _latencyChartData$tra : [],
    markerValue: (_latencyChartData$per = latencyChartData === null || latencyChartData === void 0 ? void 0 : latencyChartData.percentileThresholdValue) !== null && _latencyChartData$per !== void 0 ? _latencyChartData$per : 0,
    markerCurrentEvent: transactionDuration,
    hasData: !!latencyChartData,
    loading: latencyChartLoading,
    hasError: latencyChartHasError,
    eventType: _apmTypesShared.ProcessorEvent.transaction,
    showAxisTitle: false,
    showLegend: false,
    dataTestSubPrefix: "docViewerTransactionOverview"
  })))));
}