"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.FieldHoverActionPopover = void 0;
var _react = _interopRequireWildcard(require("react"));
var _eui = require("@elastic/eui");
var _use_field_actions = require("../../../../../hooks/use_field_actions");
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the "Elastic License
 * 2.0", the "GNU Affero General Public License v3.0 only", and the "Server Side
 * Public License v 1"; you may not use this file except in compliance with, at
 * your election, the "Elastic License 2.0", the "GNU Affero General Public
 * License v3.0 only", or the "Server Side Public License, v 1".
 */

const FieldHoverActionPopover = ({
  children,
  title,
  field,
  fieldMapping: mapping,
  value,
  formattedValue,
  anchorPosition = 'upCenter',
  display = 'inline-block'
}) => {
  const [isPopoverOpen, setIsPopoverOpen] = (0, _react.useState)(false);
  const leaveTimer = (0, _react.useRef)(null);
  const uiFieldActions = (0, _use_field_actions.useUIFieldActions)({
    field,
    value,
    formattedValue,
    mapping
  });
  const clearTimeoutIfExists = () => {
    if (leaveTimer.current) {
      clearTimeout(leaveTimer.current);
    }
  };

  // The timeout hack is required because we are using a Popover which ideally should be used with a mouseclick,
  // but we are using it as a Tooltip. Which means we now need to manually handle the open and close
  // state using the mouse hover events. This cause the popover to close even before the user could
  // navigate actions inside it. Hence, to prevent this, we need this hack
  const onMouseEnter = () => {
    clearTimeoutIfExists();
    setIsPopoverOpen(true);
  };
  const onMouseLeave = () => {
    leaveTimer.current = setTimeout(() => {
      return setIsPopoverOpen(false);
    }, 100);
  };
  (0, _react.useEffect)(function onUnmount() {
    return () => {
      clearTimeoutIfExists();
    };
  }, []);
  return /*#__PURE__*/_react.default.createElement("span", {
    onMouseEnter: onMouseEnter,
    onMouseLeave: onMouseLeave
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiPopover, {
    button: children,
    isOpen: isPopoverOpen,
    anchorPosition: anchorPosition,
    closePopover: closePopoverPlaceholder,
    panelPaddingSize: "s",
    panelStyle: {
      minWidth: '24px'
    },
    display: display
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiPopoverTitle, {
    className: "eui-textBreakWord",
    css: {
      maxWidth: '200px'
    }
  }, title), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
    wrap: true,
    gutterSize: "none",
    alignItems: "center",
    justifyContent: "spaceBetween"
  }, uiFieldActions.map(action => /*#__PURE__*/_react.default.createElement(_eui.EuiToolTip, {
    content: action.label,
    key: action.id,
    disableScreenReaderOutput: true
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiButtonIcon, {
    "data-test-subj": "unifiedDocViewerObservabilityTracesFieldHoverActionPopoverButton",
    size: "xs",
    iconType: action.iconType,
    "aria-label": action.label,
    onClick: action.onClick
  }))))));
};
exports.FieldHoverActionPopover = FieldHoverActionPopover;
const closePopoverPlaceholder = () => {};