"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.SHOW_ONLY_SELECTED_FIELDS = exports.HIDE_NULL_VALUES = exports.DocViewerTable = void 0;
var _extends2 = _interopRequireDefault(require("@babel/runtime/helpers/extends"));
var _react = _interopRequireWildcard(require("react"));
var _useWindowSize = _interopRequireDefault(require("react-use/lib/useWindowSize"));
var _useLocalStorage = _interopRequireDefault(require("react-use/lib/useLocalStorage"));
var _eui = require("@elastic/eui");
var _i18n = require("@kbn/i18n");
var _react2 = require("@emotion/react");
var _discoverUtils = require("@kbn/discover-utils");
var _use_memo_css = require("@kbn/css-utils/public/use_memo_css");
var _plugin = require("../../plugin");
var _table_cell_actions = require("./table_cell_actions");
var _get_height = require("../doc_viewer_source/get_height");
var _table_filters = require("./table_filters");
var _table_cell = require("./table_cell");
var _get_pin_control = require("./get_pin_control");
var _field_row = require("./field_row");
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the "Elastic License
 * 2.0", the "GNU Affero General Public License v3.0 only", and the "Server Side
 * Public License v 1"; you may not use this file except in compliance with, at
 * your election, the "Elastic License 2.0", the "GNU Affero General Public
 * License v3.0 only", or the "Server Side Public License, v 1".
 */

const MIN_NAME_COLUMN_WIDTH = 150;
const MAX_NAME_COLUMN_WIDTH = 350;
const PAGE_SIZE_OPTIONS = [25, 50, 100, 250, 500];
const DEFAULT_PAGE_SIZE = 25;
const PINNED_FIELDS_KEY = 'discover:pinnedFields';
const PAGE_SIZE = 'discover:pageSize';
const HIDE_NULL_VALUES = exports.HIDE_NULL_VALUES = 'unifiedDocViewer:hideNullValues';
const SHOW_ONLY_SELECTED_FIELDS = exports.SHOW_ONLY_SELECTED_FIELDS = 'unifiedDocViewer:showOnlySelectedFields';
const GRID_COLUMN_FIELD_NAME = 'name';
const GRID_COLUMN_FIELD_VALUE = 'value';
const GRID_PROPS = {
  columnVisibility: {
    visibleColumns: ['name', 'value'],
    setVisibleColumns: () => null
  },
  rowHeightsOptions: {
    defaultHeight: 'auto'
  },
  gridStyle: {
    border: 'horizontal',
    stripes: true,
    rowHover: 'highlight',
    header: 'underline',
    cellPadding: 'm',
    fontSize: 's'
  }
};
const getPinnedFields = (dataViewId, storage) => {
  const pinnedFieldsEntry = storage.get(PINNED_FIELDS_KEY);
  if (typeof pinnedFieldsEntry === 'object' && pinnedFieldsEntry !== null && Array.isArray(pinnedFieldsEntry[dataViewId])) {
    return pinnedFieldsEntry[dataViewId].filter(cur => typeof cur === 'string');
  }
  return [];
};
const updatePinnedFieldsState = (newFields, dataViewId, storage) => {
  let pinnedFieldsEntry = storage.get(PINNED_FIELDS_KEY);
  pinnedFieldsEntry = typeof pinnedFieldsEntry === 'object' && pinnedFieldsEntry !== null ? pinnedFieldsEntry : {};
  storage.set(PINNED_FIELDS_KEY, {
    ...pinnedFieldsEntry,
    [dataViewId]: newFields
  });
};
const getPageSize = storage => {
  const pageSize = Number(storage.get(PAGE_SIZE));
  return pageSize && PAGE_SIZE_OPTIONS.includes(pageSize) ? pageSize : DEFAULT_PAGE_SIZE;
};
const updatePageSize = (newPageSize, storage) => {
  storage.set(PAGE_SIZE, newPageSize);
};
const DocViewerTable = ({
  columns,
  columnsMeta,
  hit,
  dataView,
  textBasedHits,
  filter,
  decreaseAvailableHeightBy,
  onAddColumn,
  onRemoveColumn
}) => {
  const styles = (0, _use_memo_css.useMemoCss)(componentStyles);
  const isEsqlMode = Array.isArray(textBasedHits);
  const [containerRef, setContainerRef] = (0, _react.useState)(null);
  const {
    fieldFormats,
    storage,
    uiSettings,
    toasts
  } = (0, _plugin.getUnifiedDocViewerServices)();
  const showMultiFields = uiSettings.get(_discoverUtils.SHOW_MULTIFIELDS);
  const currentDataViewId = dataView.id;
  const [pinnedFields, setPinnedFields] = (0, _react.useState)(getPinnedFields(currentDataViewId, storage));
  const [areNullValuesHidden, setAreNullValuesHidden] = (0, _useLocalStorage.default)(HIDE_NULL_VALUES, false);
  const [showOnlySelectedFields, setShowOnlySelectedFields] = (0, _useLocalStorage.default)(SHOW_ONLY_SELECTED_FIELDS, false);
  const flattened = hit.flattened;
  const shouldShowFieldHandler = (0, _react.useMemo)(() => (0, _discoverUtils.getShouldShowFieldHandler)(Object.keys(flattened), dataView, showMultiFields), [flattened, dataView, showMultiFields]);
  const mapping = (0, _react.useCallback)(name => dataView.fields.getByName(name), [dataView.fields]);
  const onToggleColumn = (0, _react.useMemo)(() => {
    if (!onRemoveColumn || !onAddColumn || !columns) {
      return undefined;
    }
    return field => {
      if (columns.includes(field)) {
        onRemoveColumn(field);
      } else {
        onAddColumn(field);
      }
    };
  }, [onRemoveColumn, onAddColumn, columns]);
  const onTogglePinned = (0, _react.useCallback)(field => {
    const newPinned = pinnedFields.includes(field) ? pinnedFields.filter(curField => curField !== field) : [...pinnedFields, field];
    updatePinnedFieldsState(newPinned, currentDataViewId, storage);
    setPinnedFields(newPinned);
  }, [currentDataViewId, pinnedFields, storage]);
  const {
    onFilterField,
    onFindSearchTermMatch,
    ...tableFiltersProps
  } = (0, _table_filters.useTableFilters)({
    storage,
    storageKey: _table_filters.LOCAL_STORAGE_KEY_SEARCH_TERM
  });
  const fieldToItem = (0, _react.useCallback)((field, isPinned) => {
    return new _field_row.FieldRow({
      name: field,
      flattenedValue: flattened[field],
      hit,
      dataView,
      fieldFormats,
      isPinned,
      columnsMeta
    });
  }, [dataView, hit, columnsMeta, flattened, fieldFormats]);
  const fieldsFromColumns = (0, _react.useMemo)(() => (columns === null || columns === void 0 ? void 0 : columns.filter(column => column !== '_source')) || [], [columns]);
  const isShowOnlySelectedFieldsDisabled = !(fieldsFromColumns !== null && fieldsFromColumns !== void 0 && fieldsFromColumns.length);
  const shouldShowOnlySelectedFields = (0, _react.useMemo)(() => showOnlySelectedFields && !isShowOnlySelectedFieldsDisabled, [showOnlySelectedFields, isShowOnlySelectedFieldsDisabled]);
  const displayedFieldNames = (0, _react.useMemo)(() => {
    if (shouldShowOnlySelectedFields) {
      return (0, _discoverUtils.getVisibleColumns)(fieldsFromColumns, dataView, (0, _discoverUtils.canPrependTimeFieldColumn)(columns, dataView.timeFieldName, columnsMeta, !uiSettings.get(_discoverUtils.DOC_HIDE_TIME_COLUMN_SETTING, false), isEsqlMode));
    }
    return Object.keys(flattened).sort((fieldA, fieldB) => {
      const mappingA = mapping(fieldA);
      const mappingB = mapping(fieldB);
      const nameA = !mappingA || !mappingA.displayName ? fieldA : mappingA.displayName;
      const nameB = !mappingB || !mappingB.displayName ? fieldB : mappingB.displayName;
      return nameA.localeCompare(nameB);
    });
  }, [fieldsFromColumns, flattened, shouldShowOnlySelectedFields, mapping, dataView, columns, columnsMeta, isEsqlMode, uiSettings]);
  const {
    pinnedRows,
    restRows,
    allFields
  } = (0, _react.useMemo)(() => displayedFieldNames.reduce((acc, curFieldName) => {
    var _row$dataViewField;
    if (!shouldShowOnlySelectedFields && !shouldShowFieldHandler(curFieldName)) {
      return acc;
    }
    const shouldHideNullValue = isEsqlMode && areNullValuesHidden && flattened[curFieldName] == null;
    if (shouldHideNullValue) {
      return acc;
    }
    const isPinned = pinnedFields.includes(curFieldName);
    const row = fieldToItem(curFieldName, isPinned);
    if (isPinned) {
      acc.pinnedRows.push(row);
    } else {
      if (onFilterField(row)) {
        // filter only unpinned fields
        acc.restRows.push(row);
      }
    }
    acc.allFields.push({
      name: curFieldName,
      displayName: (_row$dataViewField = row.dataViewField) === null || _row$dataViewField === void 0 ? void 0 : _row$dataViewField.displayName,
      type: row.fieldType
    });
    return acc;
  }, {
    pinnedRows: [],
    restRows: [],
    allFields: []
  }), [displayedFieldNames, areNullValuesHidden, shouldShowOnlySelectedFields, fieldToItem, flattened, isEsqlMode, onFilterField, pinnedFields, shouldShowFieldHandler]);
  const rows = (0, _react.useMemo)(() => [...pinnedRows, ...restRows], [pinnedRows, restRows]);
  const leadingControlColumns = (0, _react.useMemo)(() => {
    return [(0, _get_pin_control.getPinColumnControl)({
      rows,
      onTogglePinned
    })];
  }, [rows, onTogglePinned]);
  const {
    curPageIndex,
    pageSize,
    totalPages,
    changePageIndex,
    changePageSize
  } = (0, _discoverUtils.usePager)({
    initialPageSize: getPageSize(storage),
    totalItems: rows.length
  });
  const showPagination = totalPages !== 0;
  const onChangePageSize = (0, _react.useCallback)(newPageSize => {
    updatePageSize(newPageSize, storage);
    changePageSize(newPageSize);
  }, [changePageSize, storage]);
  const pagination = (0, _react.useMemo)(() => {
    return showPagination ? {
      onChangeItemsPerPage: onChangePageSize,
      onChangePage: changePageIndex,
      pageIndex: curPageIndex,
      pageSize,
      pageSizeOptions: PAGE_SIZE_OPTIONS
    } : undefined;
  }, [showPagination, curPageIndex, pageSize, onChangePageSize, changePageIndex]);
  const fieldCellActions = (0, _react.useMemo)(() => (0, _table_cell_actions.getFieldCellActions)({
    rows,
    isEsqlMode,
    onFilter: filter,
    onToggleColumn
  }), [rows, isEsqlMode, filter, onToggleColumn]);
  const fieldValueCellActions = (0, _react.useMemo)(() => (0, _table_cell_actions.getFieldValueCellActions)({
    rows,
    isEsqlMode,
    toasts,
    onFilter: filter
  }), [rows, isEsqlMode, toasts, filter]);
  (0, _useWindowSize.default)(); // trigger re-render on window resize to recalculate the grid container height
  const {
    width: containerWidth
  } = (0, _eui.useResizeObserver)(containerRef);
  const gridColumns = (0, _react.useMemo)(() => [{
    id: GRID_COLUMN_FIELD_NAME,
    displayAsText: _i18n.i18n.translate('unifiedDocViewer.fieldChooser.discoverField.name', {
      defaultMessage: 'Field'
    }),
    initialWidth: Math.min(Math.max(Math.round(containerWidth * 0.3), MIN_NAME_COLUMN_WIDTH), MAX_NAME_COLUMN_WIDTH),
    actions: false,
    visibleCellActions: 3,
    cellActions: fieldCellActions
  }, {
    id: GRID_COLUMN_FIELD_VALUE,
    displayAsText: _i18n.i18n.translate('unifiedDocViewer.fieldChooser.discoverField.value', {
      defaultMessage: 'Value'
    }),
    actions: false,
    visibleCellActions: 3,
    cellActions: fieldValueCellActions
  }], [fieldCellActions, fieldValueCellActions, containerWidth]);
  const onHideNullValuesChange = (0, _react.useCallback)(e => {
    setAreNullValuesHidden(e.target.checked);
  }, [setAreNullValuesHidden]);
  const onShowOnlySelectedFieldsChange = (0, _react.useCallback)(e => {
    setShowOnlySelectedFields(e.target.checked);
  }, [setShowOnlySelectedFields]);
  const renderCellValue = (0, _react.useCallback)(({
    rowIndex,
    columnId,
    isDetails
  }) => {
    return /*#__PURE__*/_react.default.createElement(_table_cell.TableCell, {
      searchTerm: tableFiltersProps.searchTerm,
      rows: rows,
      rowIndex: rowIndex,
      columnId: columnId,
      isDetails: isDetails,
      onFindSearchTermMatch: onFindSearchTermMatch
    });
  }, [rows, tableFiltersProps.searchTerm, onFindSearchTermMatch]);
  const renderCellPopover = (0, _react.useCallback)(props => {
    const {
      columnId,
      children,
      cellActions,
      rowIndex
    } = props;
    const row = rows[rowIndex];
    let warningMessage;
    if (columnId === GRID_COLUMN_FIELD_VALUE) {
      warningMessage = (0, _table_cell_actions.getFilterInOutPairDisabledWarning)(row, filter);
    } else if (columnId === GRID_COLUMN_FIELD_NAME) {
      warningMessage = (0, _table_cell_actions.getFilterExistsDisabledWarning)(row, filter);
    }
    return /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, /*#__PURE__*/_react.default.createElement(_eui.EuiText, {
      size: "s"
    }, children), cellActions, Boolean(warningMessage) && /*#__PURE__*/_react.default.createElement("div", null, /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, {
      size: "xs"
    }), /*#__PURE__*/_react.default.createElement(_eui.EuiCallOut, {
      title: warningMessage,
      color: "warning",
      size: "s"
    })));
  }, [rows, filter]);
  const containerHeight = containerRef ? (0, _get_height.getTabContentAvailableHeight)(containerRef, decreaseAvailableHeightBy !== null && decreaseAvailableHeightBy !== void 0 ? decreaseAvailableHeightBy : _get_height.DEFAULT_MARGIN_BOTTOM) : 0;
  return /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
    ref: setContainerRef,
    direction: "column",
    gutterSize: "none",
    responsive: false,
    css: containerHeight ? (0, _react2.css)`
              height: ${containerHeight}px;
            ` : (0, _react2.css)`
              display: block;
            `
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    grow: false
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, {
    size: "s"
  })), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    grow: false
  }, /*#__PURE__*/_react.default.createElement(_table_filters.TableFilters, (0, _extends2.default)({}, tableFiltersProps, {
    allFields: allFields
  }))), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    grow: false
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, {
    size: "s"
  })), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    grow: false
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
    responsive: false,
    wrap: true,
    direction: "row",
    justifyContent: "flexEnd",
    alignItems: "center",
    gutterSize: "m"
  }, filter && /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    grow: false
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiSwitch, {
    label: _i18n.i18n.translate('unifiedDocViewer.showOnlySelectedFields.switchLabel', {
      defaultMessage: 'Selected only',
      description: 'Switch label to show only selected fields in the table'
    }),
    checked: showOnlySelectedFields !== null && showOnlySelectedFields !== void 0 ? showOnlySelectedFields : false,
    disabled: isShowOnlySelectedFieldsDisabled,
    onChange: onShowOnlySelectedFieldsChange,
    compressed: true,
    "data-test-subj": "unifiedDocViewerShowOnlySelectedFieldsSwitch"
  })), isEsqlMode && /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    grow: false
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiSwitch, {
    label: _i18n.i18n.translate('unifiedDocViewer.hideNullValues.switchLabel', {
      defaultMessage: 'Hide null fields',
      description: 'Switch label to hide fields with null values in the table'
    }),
    checked: areNullValuesHidden !== null && areNullValuesHidden !== void 0 ? areNullValuesHidden : false,
    onChange: onHideNullValuesChange,
    compressed: true,
    "data-test-subj": "unifiedDocViewerHideNullValuesSwitch"
  })))), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    grow: false
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, {
    size: "s"
  })), rows.length === 0 ? /*#__PURE__*/_react.default.createElement(_eui.EuiSelectableMessage, {
    css: styles.noFieldsFound
  }, /*#__PURE__*/_react.default.createElement("p", null, /*#__PURE__*/_react.default.createElement(_eui.EuiI18n, {
    token: "unifiedDocViewer.docViews.table.noFieldFound",
    default: "No fields found"
  }))) : /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    grow: Boolean(containerHeight),
    css: styles.fieldsGridWrapper
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiDataGrid, (0, _extends2.default)({
    key: `fields-table-${hit.id}`
  }, GRID_PROPS, {
    "aria-label": _i18n.i18n.translate('unifiedDocViewer.fieldsTable.ariaLabel', {
      defaultMessage: 'Field values'
    }),
    className: "kbnDocViewer__fieldsGrid",
    css: styles.fieldsGrid,
    columns: gridColumns,
    toolbarVisibility: false,
    rowCount: rows.length,
    renderCellValue: renderCellValue,
    renderCellPopover: renderCellPopover,
    pagination: pagination,
    leadingControlColumns: leadingControlColumns
  }))));
};
exports.DocViewerTable = DocViewerTable;
const componentStyles = {
  fieldsGridWrapper: ({
    euiTheme
  }) => (0, _react2.css)({
    minBlockSize: 0,
    display: 'block',
    '.euiDataGridRow': {
      '&:hover': {
        // we keep using a deprecated shade until proper token is available
        backgroundColor: euiTheme.colors.lightestShade
      }
    }
  }),
  fieldsGrid: themeContext => {
    const {
      euiTheme
    } = themeContext;
    const {
      fontSize
    } = (0, _eui.euiFontSize)(themeContext, 's');
    return (0, _react2.css)({
      '&.euiDataGrid--noControls.euiDataGrid--bordersHorizontal .euiDataGridHeader': {
        borderTop: 'none'
      },
      '&.euiDataGrid--headerUnderline .euiDataGridHeader': {
        borderBottom: euiTheme.border.thin
      },
      '& [data-gridcell-column-id="name"] .euiDataGridRowCell__content': {
        paddingTop: 0,
        paddingBottom: 0
      },
      '& [data-gridcell-column-id="pin_field"] .euiDataGridRowCell__content': {
        padding: `calc(${euiTheme.size.xs} / 2) 0 0 ${euiTheme.size.xs}`
      },
      '.kbnDocViewer__fieldName': {
        padding: euiTheme.size.xs,
        paddingLeft: 0,
        lineHeight: euiTheme.font.lineHeightMultiplier,
        '.euiDataGridRowCell__popover &': {
          fontSize
        }
      },
      '.kbnDocViewer__fieldName_icon': {
        paddingTop: `calc(${euiTheme.size.xs} * 1.5)`,
        lineHeight: euiTheme.font.lineHeightMultiplier
      },
      '.kbnDocViewer__fieldName_multiFieldBadge': {
        margin: `${euiTheme.size.xs} 0`,
        fontWeight: euiTheme.font.weight.regular,
        fontFamily: euiTheme.font.family
      },
      '.kbnDocViewer__fieldsGrid__pinAction': {
        opacity: 0
      },
      '& [data-gridcell-column-id="pin_field"]:focus-within': {
        '.kbnDocViewer__fieldsGrid__pinAction': {
          opacity: 1
        }
      },
      '.euiDataGridRow:hover .kbnDocViewer__fieldsGrid__pinAction': {
        opacity: 1
      }
    });
  },
  noFieldsFound: (0, _react2.css)({
    minHeight: 300
  })
};