"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.FieldRow = void 0;
var _defineProperty2 = _interopRequireDefault(require("@babel/runtime/helpers/defineProperty"));
var _discoverUtils = require("@kbn/discover-utils");
var _fieldUtils = require("@kbn/field-utils");
var _dataViewUtils = require("@kbn/data-view-utils");
function _classPrivateFieldInitSpec(e, t, a) { _checkPrivateRedeclaration(e, t), t.set(e, a); }
function _checkPrivateRedeclaration(e, t) { if (t.has(e)) throw new TypeError("Cannot initialize the same private elements twice on an object"); }
function _classPrivateFieldGet(s, a) { return s.get(_assertClassBrand(s, a)); }
function _classPrivateFieldSet(s, a, r) { return s.set(_assertClassBrand(s, a), r), r; }
function _assertClassBrand(e, t, n) { if ("function" == typeof e ? e === t : e.has(t)) return arguments.length < 3 ? t : n; throw new TypeError("Private element is not present on this object"); } /*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the "Elastic License
 * 2.0", the "GNU Affero General Public License v3.0 only", and the "Server Side
 * Public License v 1"; you may not use this file except in compliance with, at
 * your election, the "Elastic License 2.0", the "GNU Affero General Public
 * License v3.0 only", or the "Server Side Public License, v 1".
 */
var _hit = /*#__PURE__*/new WeakMap();
var _dataView = /*#__PURE__*/new WeakMap();
var _fieldFormats = /*#__PURE__*/new WeakMap();
var _isFormattedAsHtml = /*#__PURE__*/new WeakMap();
var _isFormattedAsText = /*#__PURE__*/new WeakMap();
var _formattedAsHtml = /*#__PURE__*/new WeakMap();
var _formattedAsText = /*#__PURE__*/new WeakMap();
var _fieldType = /*#__PURE__*/new WeakMap();
class FieldRow {
  constructor({
    name,
    displayNameOverride,
    flattenedValue,
    hit,
    dataView,
    fieldFormats,
    isPinned,
    columnsMeta
  }) {
    (0, _defineProperty2.default)(this, "name", void 0);
    (0, _defineProperty2.default)(this, "displayNameOverride", void 0);
    (0, _defineProperty2.default)(this, "flattenedValue", void 0);
    (0, _defineProperty2.default)(this, "dataViewField", void 0);
    (0, _defineProperty2.default)(this, "isPinned", void 0);
    (0, _defineProperty2.default)(this, "columnsMeta", void 0);
    _classPrivateFieldInitSpec(this, _hit, void 0);
    _classPrivateFieldInitSpec(this, _dataView, void 0);
    _classPrivateFieldInitSpec(this, _fieldFormats, void 0);
    _classPrivateFieldInitSpec(this, _isFormattedAsHtml, void 0);
    _classPrivateFieldInitSpec(this, _isFormattedAsText, void 0);
    _classPrivateFieldInitSpec(this, _formattedAsHtml, void 0);
    _classPrivateFieldInitSpec(this, _formattedAsText, void 0);
    _classPrivateFieldInitSpec(this, _fieldType, void 0);
    _classPrivateFieldSet(_hit, this, hit);
    _classPrivateFieldSet(_dataView, this, dataView);
    _classPrivateFieldSet(_fieldFormats, this, fieldFormats);
    _classPrivateFieldSet(_isFormattedAsHtml, this, false);
    _classPrivateFieldSet(_isFormattedAsText, this, false);
    this.name = name;
    this.displayNameOverride = displayNameOverride;
    this.flattenedValue = flattenedValue;
    this.dataViewField = (0, _dataViewUtils.getDataViewFieldOrCreateFromColumnMeta)({
      dataView,
      fieldName: name,
      columnMeta: columnsMeta === null || columnsMeta === void 0 ? void 0 : columnsMeta[name]
    });
    this.isPinned = isPinned;
    this.columnsMeta = columnsMeta;
  }

  // format as html in a lazy way
  get formattedAsHtml() {
    if (!_classPrivateFieldGet(_isFormattedAsHtml, this)) {
      _classPrivateFieldSet(_formattedAsHtml, this, (0, _discoverUtils.formatFieldValue)(this.flattenedValue, _classPrivateFieldGet(_hit, this).raw, _classPrivateFieldGet(_fieldFormats, this), _classPrivateFieldGet(_dataView, this), this.dataViewField, 'html'));
      _classPrivateFieldSet(_isFormattedAsHtml, this, true);
    }
    return _classPrivateFieldGet(_formattedAsHtml, this);
  }

  // format as text in a lazy way
  get formattedAsText() {
    if (!_classPrivateFieldGet(_isFormattedAsText, this)) {
      _classPrivateFieldSet(_formattedAsText, this, (0, _discoverUtils.convertValueToString)({
        dataView: _classPrivateFieldGet(_dataView, this),
        dataViewField: this.dataViewField,
        flattenedValue: this.flattenedValue,
        dataTableRecord: _classPrivateFieldGet(_hit, this),
        fieldFormats: _classPrivateFieldGet(_fieldFormats, this),
        options: {
          compatibleWithCSV: true
        }
      }).formattedString);
      _classPrivateFieldSet(_isFormattedAsText, this, true);
    }
    return _classPrivateFieldGet(_formattedAsText, this);
  }
  get fieldType() {
    if (!_classPrivateFieldGet(_fieldType, this)) {
      var _this$columnsMeta;
      const columnMeta = (_this$columnsMeta = this.columnsMeta) === null || _this$columnsMeta === void 0 ? void 0 : _this$columnsMeta[this.name];
      const columnIconType = (0, _fieldUtils.getTextBasedColumnIconType)(columnMeta);
      const fieldType = columnIconType ? columnIconType // for text-based results types come separately
      : (0, _discoverUtils.isNestedFieldParent)(this.name, _classPrivateFieldGet(_dataView, this)) ? 'nested' : this.dataViewField ? (0, _fieldUtils.getFieldIconType)(this.dataViewField) : undefined;
      _classPrivateFieldSet(_fieldType, this, fieldType);
    }
    return _classPrivateFieldGet(_fieldType, this);
  }
  get ignoredReason() {
    return this.dataViewField ? (0, _discoverUtils.getIgnoredReason)(this.dataViewField, _classPrivateFieldGet(_hit, this).raw._ignored) : undefined;
  }
}
exports.FieldRow = FieldRow;