"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.DrilldownForm = void 0;
var _extends2 = _interopRequireDefault(require("@babel/runtime/helpers/extends"));
var _react = _interopRequireDefault(require("react"));
var _eui = require("@elastic/eui");
var _i18n = require("@kbn/i18n");
var _trigger_picker = require("../trigger_picker");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the "Elastic License
 * 2.0", the "GNU Affero General Public License v3.0 only", and the "Server Side
 * Public License v 1"; you may not use this file except in compliance with, at
 * your election, the "Elastic License 2.0", the "GNU Affero General Public
 * License v3.0 only", or the "Server Side Public License, v 1".
 */

const txtNameOfDrilldown = _i18n.i18n.translate('uiActionsEnhanced.components.DrilldownForm.nameOfDrilldown', {
  defaultMessage: 'Name'
});
const txtUntitledDrilldown = _i18n.i18n.translate('uiActionsEnhanced.components.DrilldownForm.untitledDrilldown', {
  defaultMessage: 'Untitled drilldown'
});
const txtTrigger = _i18n.i18n.translate('uiActionsEnhanced.components.DrilldownForm.trigger', {
  defaultMessage: 'Trigger'
});
const DrilldownForm = ({
  name = '',
  onNameChange,
  triggers,
  disabled,
  children
}) => {
  if (!!triggers && !triggers.items.length) {
    // Below callout is not translated, because this message is only for developers.
    return /*#__PURE__*/_react.default.createElement(_eui.EuiCallOut, {
      title: "Sorry, there was an error",
      color: "danger",
      iconType: "warning"
    }, /*#__PURE__*/_react.default.createElement("p", null, "No triggers provided in ", /*#__PURE__*/_react.default.createElement(_eui.EuiCode, null, "triggers"), " prop."));
  }
  const nameFragment = /*#__PURE__*/_react.default.createElement(_eui.EuiFormRow, {
    label: txtNameOfDrilldown
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFieldText, {
    name: "drilldown_name",
    placeholder: txtUntitledDrilldown,
    value: name,
    disabled: !onNameChange || disabled,
    onChange: !!onNameChange ? event => onNameChange(event.target.value) : undefined,
    "data-test-subj": "drilldownNameInput"
  }));
  const triggersFragment = !!triggers && triggers.items.length > 0 && /*#__PURE__*/_react.default.createElement(_eui.EuiFormRow, {
    label: txtTrigger,
    fullWidth: true
  }, /*#__PURE__*/_react.default.createElement(_trigger_picker.TriggerPicker, (0, _extends2.default)({}, triggers, {
    disabled: disabled
  })));
  return /*#__PURE__*/_react.default.createElement(_eui.EuiForm, {
    "data-test-subj": `DrilldownForm`
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, {
    size: 'm'
  }), nameFragment, /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, {
    size: 'm'
  }), triggersFragment, /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, {
    size: 'm'
  }), /*#__PURE__*/_react.default.createElement("div", null, children));
};
exports.DrilldownForm = DrilldownForm;