"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.ActionFactory = void 0;
var _eui = require("@elastic/eui");
var _react = _interopRequireDefault(require("react"));
var _i18n = require("@kbn/i18n");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the "Elastic License
 * 2.0", the "GNU Affero General Public License v3.0 only", and the "Server Side
 * Public License v 1"; you may not use this file except in compliance with, at
 * your election, the "Elastic License 2.0", the "GNU Affero General Public
 * License v3.0 only", or the "Server Side Public License, v 1".
 */

const txtDrilldownAction = _i18n.i18n.translate('uiActionsEnhanced.components.DrilldownForm.drilldownAction', {
  defaultMessage: 'Action'
});
const txtGetMoreActions = _i18n.i18n.translate('uiActionsEnhanced.components.DrilldownForm.getMoreActionsLinkLabel', {
  defaultMessage: 'Get more actions'
});
const txtBetaActionFactoryLabel = _i18n.i18n.translate('uiActionsEnhanced.components.DrilldownForm.betaActionLabel', {
  defaultMessage: `Beta`
});
const txtBetaActionFactoryTooltip = _i18n.i18n.translate('uiActionsEnhanced.components.DrilldownForm.betaActionTooltip', {
  defaultMessage: `This action is in beta and is subject to change. The design and code is less mature than official GA features and is being provided as-is with no warranties. Beta features are not subject to the support SLA of official GA features. Please help us by reporting bugs or providing other feedback.`
});
const txtChangeButton = _i18n.i18n.translate('uiActionsEnhanced.components.DrilldownForm.changeButton', {
  defaultMessage: 'Change'
});
const GET_MORE_ACTIONS_LINK = 'https://www.elastic.co/subscriptions';
const moreActions = /*#__PURE__*/_react.default.createElement(_eui.EuiText, {
  size: "s"
}, /*#__PURE__*/_react.default.createElement(_eui.EuiLink, {
  href: GET_MORE_ACTIONS_LINK,
  target: "_blank",
  external: true,
  "data-test-subj": 'getMoreActionsLink'
}, txtGetMoreActions));
const ActionFactory = ({
  name,
  icon,
  beta,
  showMoreLink,
  onChange
}) => {
  return /*#__PURE__*/_react.default.createElement(_eui.EuiFormRow, {
    label: txtDrilldownAction,
    fullWidth: true,
    labelAppend: showMoreLink && moreActions
  }, /*#__PURE__*/_react.default.createElement("header", null, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
    alignItems: "center",
    responsive: false,
    gutterSize: "s"
  }, !!icon && /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    grow: false
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiIcon, {
    type: icon,
    size: "m"
  })), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    grow: true
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiText, null, /*#__PURE__*/_react.default.createElement("h4", null, name, ' ', beta && /*#__PURE__*/_react.default.createElement(_eui.EuiBetaBadge, {
    label: txtBetaActionFactoryLabel,
    tooltipContent: txtBetaActionFactoryTooltip
  })))), !!onChange && /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    grow: false
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiButtonEmpty, {
    size: "xs",
    "data-test-subj": "changeDrilldownType",
    onClick: onChange
  }, txtChangeButton)))));
};
exports.ActionFactory = ActionFactory;