"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.getRuleFlyoutComponent = getRuleFlyoutComponent;
var _i18n = require("@kbn/i18n");
var _lodash = require("lodash");
var _lib = require("@kbn/response-ops-rule-form/lib");
var _esqlTypes = require("@kbn/esql-types");
var _presentationContainers = require("@kbn/presentation-containers");
var _ruleDataUtils = require("@kbn/rule-data-utils");
var _react = _interopRequireDefault(require("react"));
var _esqlAst = require("@kbn/esql-ast");
var _kibana = require("../lib/kibana");
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; } /*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */
async function getRuleFlyoutComponent(startDependencies, ruleTypeRegistry, actionTypeRegistry, parentApi, passedInitialValues) {
  var _esqlVariables$$getVa, _passedInitialValues$;
  const {
    coreStart
  } = startDependencies;
  const ruleFormPlugins = {
    ...startDependencies,
    ...coreStart
  };
  const canShowRuleForm = (0, _lib.isValidRuleFormPlugins)(ruleFormPlugins) && ruleTypeRegistry && actionTypeRegistry;
  if (!canShowRuleForm) {
    throw new Error(_i18n.i18n.translate('xpack.triggersActionsUI.alertRuleFromVis.createAlertRuleError', {
      defaultMessage: 'Unable to open the alert rule form, some services are missing'
    }));
  }
  const esqlVariables$ = (0, _esqlTypes.apiPublishesESQLVariables)(parentApi) ? parentApi.esqlVariables$ : undefined;
  const esqlVariables = (_esqlVariables$$getVa = esqlVariables$ === null || esqlVariables$ === void 0 ? void 0 : esqlVariables$.getValue()) !== null && _esqlVariables$$getVa !== void 0 ? _esqlVariables$$getVa : [];
  const initialValues = esqlVariables.length ? {
    ...passedInitialValues,
    params: {
      ...(passedInitialValues === null || passedInitialValues === void 0 ? void 0 : passedInitialValues.params),
      esqlQuery: parseEsqlVariables(passedInitialValues === null || passedInitialValues === void 0 ? void 0 : (_passedInitialValues$ = passedInitialValues.params) === null || _passedInitialValues$ === void 0 ? void 0 : _passedInitialValues$.esqlQuery, esqlVariables)
    }
  } : {
    ...passedInitialValues
  };
  const overlayTracker = (0, _presentationContainers.tracksOverlays)(parentApi) ? parentApi : undefined;
  const closeRuleForm = () => {
    overlayTracker === null || overlayTracker === void 0 ? void 0 : overlayTracker.clearOverlays();
  };
  const {
    RuleFormFlyout
  } = await Promise.resolve().then(() => _interopRequireWildcard(require('@kbn/response-ops-rule-form/flyout')));
  return () => /*#__PURE__*/_react.default.createElement(_kibana.KibanaContextProvider, {
    services: ruleFormPlugins
  }, /*#__PURE__*/_react.default.createElement(RuleFormFlyout, {
    "data-test-subj": "lensEmbeddableRuleForm",
    plugins: {
      ...ruleFormPlugins,
      ruleTypeRegistry,
      actionTypeRegistry
    },
    ruleTypeId: _ruleDataUtils.ES_QUERY_ID,
    initialValues: initialValues,
    initialMetadata: {
      isManagementPage: false
    },
    onCancel: closeRuleForm,
    onSubmit: closeRuleForm,
    multiConsumerSelection: _ruleDataUtils.AlertConsumers.ALERTS
  }));
}
function parseEsqlVariables(query, variables) {
  if (!query) return query;
  let parsedQuery = query.esql;
  const variableLookup = variables.reduce((result, {
    key,
    value
  }) => ({
    ...result,
    [key]: value
  }), {});
  const {
    root
  } = (0, _esqlAst.parse)(query.esql);
  const params = _esqlAst.Walker.params(root);
  params.forEach(({
    value: variableName,
    text
  }) => {
    if (variableName in variableLookup) {
      const value = variableLookup[variableName];
      // Do NOT use a global regexp, `params` lists all variables in the query in the order they occur, including duplicates
      // We want to make sure we replace params one by one, in order, in case any param is a substring of a longer param
      // e.g. ??field and ??field1
      parsedQuery = parsedQuery.replace(new RegExp((0, _lodash.escapeRegExp)(text)), String(value));
    }
  });
  return {
    esql: parsedQuery
  };
}