"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.DeleteModalConfirmation = void 0;
var _eui = require("@elastic/eui");
var _react = _interopRequireWildcard(require("react"));
var _kibana = require("../../common/lib/kibana");
var _translations = require("../sections/rules_list/translations");
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const DeleteModalConfirmation = ({
  idsToDelete,
  apiDeleteCall,
  onDeleted,
  onCancel,
  onErrors,
  singleTitle,
  multipleTitle,
  showWarningText,
  warningText,
  setIsLoadingState
}) => {
  const [deleteModalFlyoutVisible, setDeleteModalVisibility] = (0, _react.useState)(false);
  (0, _react.useEffect)(() => {
    setDeleteModalVisibility(idsToDelete.length > 0);
  }, [idsToDelete]);
  const {
    http,
    notifications: {
      toasts
    }
  } = (0, _kibana.useKibana)().services;
  const modalTitleId = (0, _eui.useGeneratedHtmlId)();
  const numIdsToDelete = idsToDelete.length;
  if (!deleteModalFlyoutVisible) {
    return null;
  }
  return /*#__PURE__*/_react.default.createElement(_eui.EuiConfirmModal, {
    "aria-labelledby": modalTitleId,
    buttonColor: "danger",
    "data-test-subj": "deleteIdsConfirmation",
    title: (0, _translations.getConfirmDeletionButtonText)(numIdsToDelete, singleTitle, multipleTitle),
    titleProps: {
      id: modalTitleId
    },
    onCancel: () => {
      setDeleteModalVisibility(false);
      onCancel();
    },
    onConfirm: async () => {
      setDeleteModalVisibility(false);
      setIsLoadingState(true);
      const {
        successes,
        errors
      } = await apiDeleteCall({
        ids: idsToDelete,
        http
      });
      setIsLoadingState(false);
      const numSuccesses = successes.length;
      const numErrors = errors.length;
      if (numErrors > 0) {
        toasts.addDanger((0, _translations.getFailedDeletionNotificationText)(numErrors, singleTitle, multipleTitle));
        await onErrors();
      }
      if (numSuccesses > 0) {
        toasts.addSuccess((0, _translations.getSuccessfulDeletionNotificationText)(numSuccesses, singleTitle, multipleTitle));
        await onDeleted(successes);
      }
    },
    cancelButtonText: _translations.CANCEL_BUTTON_TEXT,
    confirmButtonText: (0, _translations.getConfirmDeletionButtonText)(numIdsToDelete, singleTitle, multipleTitle)
  }, /*#__PURE__*/_react.default.createElement("p", null, (0, _translations.getConfirmDeletionModalText)(numIdsToDelete, singleTitle, multipleTitle)), showWarningText && /*#__PURE__*/_react.default.createElement(_eui.EuiCallOut, {
    title: /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, warningText),
    color: "warning",
    iconType: "warning"
  }));
};
exports.DeleteModalConfirmation = DeleteModalConfirmation;