"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.isDeleteActionDisabled = exports.getDeleteActionDisabledMessage = exports.deleteActionNameText = exports.DeleteActionName = void 0;
var _react = _interopRequireDefault(require("react"));
var _i18n = require("@kbn/i18n");
var _eui = require("@elastic/eui");
var _transform_list = require("../../../../common/transform_list");
var _create_stats_unknown_message = require("../../../../../../common/utils/create_stats_unknown_message");
var _create_capability_failure_message = require("../../../../../../common/utils/create_capability_failure_message");
var _constants = require("../../../../../../common/constants");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const deleteActionNameText = exports.deleteActionNameText = _i18n.i18n.translate('xpack.transform.transformList.deleteActionNameText', {
  defaultMessage: 'Delete'
});
const transformCanNotBeDeleted = i => i.stats && ![_constants.TRANSFORM_STATE.STOPPED, _constants.TRANSFORM_STATE.FAILED].includes(i.stats.state);
const isDeleteActionDisabled = (items, forceDisable) => {
  const disabled = items.some(transformCanNotBeDeleted);
  return forceDisable === true || disabled || (0, _transform_list.missingTransformStats)(items);
};
exports.isDeleteActionDisabled = isDeleteActionDisabled;
const getDeleteActionDisabledMessage = ({
  items,
  canDeleteTransform,
  forceDisable
}) => {
  const isBulkAction = items.length > 1;
  if ((0, _transform_list.missingTransformStats)(items)) {
    return (0, _create_stats_unknown_message.createNoStatsTooltipMessage)({
      actionName: deleteActionNameText,
      count: items.length
    });
  }
  if (!canDeleteTransform) {
    return (0, _create_capability_failure_message.createCapabilityFailureMessage)('canDeleteTransform');
  }
  const disabled = items.some(transformCanNotBeDeleted);
  if (disabled) {
    return isBulkAction === true ? _i18n.i18n.translate('xpack.transform.transformList.deleteBulkActionDisabledToolTipContent', {
      defaultMessage: 'One or more selected transforms must be stopped in order to be deleted.'
    }) : _i18n.i18n.translate('xpack.transform.transformList.deleteActionDisabledToolTipContent', {
      defaultMessage: 'Stop the transform in order to delete it.'
    });
  }
};
exports.getDeleteActionDisabledMessage = getDeleteActionDisabledMessage;
const DeleteActionName = ({
  items,
  canDeleteTransform,
  disabled,
  isBulkAction,
  forceDisable
}) => {
  const content = getDeleteActionDisabledMessage({
    items,
    canDeleteTransform,
    forceDisable
  });
  if (content) {
    return /*#__PURE__*/_react.default.createElement(_eui.EuiToolTip, {
      position: "top",
      content: content
    }, /*#__PURE__*/_react.default.createElement("span", {
      tabIndex: 0
    }, deleteActionNameText));
  }
  return /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, deleteActionNameText);
};
exports.DeleteActionName = DeleteActionName;