"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.useSearchBar = void 0;
var _react = require("react");
var _esQuery = require("@kbn/es-query");
var _common = require("../../../../../common");
var _common2 = require("../common");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const useSearchBar = (defaults, dataView) => {
  // The internal state of the input query bar updated on every key stroke.
  const [searchInput, setSearchInput] = (0, _react.useState)({
    query: defaults.searchString || '',
    language: defaults.searchLanguage
  });

  // The state of the input query bar updated on every submit and to be exposed.
  const [searchLanguage, setSearchLanguage] = (0, _react.useState)(defaults.searchLanguage);
  const [searchString, setSearchString] = (0, _react.useState)(defaults.searchString);
  const [searchQuery, setSearchQuery] = (0, _react.useState)(defaults.searchQuery);
  const [queryErrorMessage, setQueryErrorMessage] = (0, _react.useState)(undefined);
  const searchChangeHandler = query => setSearchInput(query);
  const searchSubmitHandler = query => {
    setSearchLanguage(query.language);
    setSearchString(query.query !== '' ? query.query : undefined);
    try {
      switch (query.language) {
        case _common2.QUERY_LANGUAGE_KUERY:
          setSearchQuery((0, _esQuery.toElasticsearchQuery)((0, _esQuery.fromKueryExpression)(query.query), dataView));
          return;
        case _common2.QUERY_LANGUAGE_LUCENE:
          setSearchQuery((0, _esQuery.luceneStringToDsl)(query.query));
          return;
      }
    } catch (e) {
      setQueryErrorMessage({
        query: query.query,
        message: e.message
      });
    }
  };
  const transformConfigQuery = (0, _common.getTransformConfigQuery)(searchQuery);
  return {
    actions: {
      searchChangeHandler,
      searchSubmitHandler,
      setQueryErrorMessage,
      setSearchInput,
      setSearchLanguage,
      setSearchQuery,
      setSearchString
    },
    state: {
      queryErrorMessage,
      transformConfigQuery,
      searchInput,
      searchLanguage,
      searchQuery,
      searchString
    }
  };
};
exports.useSearchBar = useSearchBar;