"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.getTopMetricsAggConfig = getTopMetricsAggConfig;
var _mlIsPopulatedObject = require("@kbn/ml-is-populated-object");
var _pivot_aggs = require("../../../../../../common/pivot_aggs");
var _top_metrics_agg_form = require("./components/top_metrics_agg_form");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

/**
 * Gets initial basic configuration of the top_metrics aggregation.
 */
function getTopMetricsAggConfig(commonConfig) {
  return {
    ...commonConfig,
    isSubAggsSupported: false,
    isMultiField: true,
    field: (0, _pivot_aggs.isPivotAggsConfigWithUiBase)(commonConfig) ? commonConfig.field : '',
    AggFormComponent: _top_metrics_agg_form.TopMetricsAggForm,
    aggConfig: {},
    getEsAggConfig() {
      // ensure the configuration has been completed
      if (!this.isValid()) {
        return null;
      }
      const {
        sortField,
        sortSettings = {},
        ...unsupportedConfig
      } = this.aggConfig;
      let sort = null;
      if ((0, _pivot_aggs.isSpecialSortField)(sortField)) {
        sort = sortField;
      } else {
        const {
          mode,
          numericType,
          order,
          ...rest
        } = sortSettings;
        if (mode || numericType || (0, _mlIsPopulatedObject.isPopulatedObject)(rest)) {
          sort = {
            [sortField]: {
              ...rest,
              order,
              ...(mode ? {
                mode
              } : {}),
              ...(numericType ? {
                numeric_type: numericType
              } : {})
            }
          };
        } else {
          sort = {
            [sortField]: sortSettings.order
          };
        }
      }
      return {
        metrics: (Array.isArray(this.field) ? this.field : [this.field]).map(f => ({
          field: f
        })),
        sort: sort,
        ...(unsupportedConfig !== null && unsupportedConfig !== void 0 ? unsupportedConfig : {})
      };
    },
    setUiConfigFromEs(esAggDefinition) {
      var _this$aggConfig$sortS;
      const {
        metrics,
        sort,
        ...unsupportedConfig
      } = esAggDefinition;
      this.field = (Array.isArray(metrics) ? metrics : [metrics]).map(v => v.field);
      if ((0, _pivot_aggs.isSpecialSortField)(sort)) {
        this.aggConfig.sortField = sort;
        return;
      }
      if (!sort) {
        this.aggConfig = {
          ...this.aggConfig,
          ...(unsupportedConfig !== null && unsupportedConfig !== void 0 ? unsupportedConfig : {})
        };
        return;
      }
      const sortField = Object.keys(sort)[0];
      this.aggConfig.sortField = sortField;
      const sortDefinition = sort[sortField];
      this.aggConfig.sortSettings = (_this$aggConfig$sortS = this.aggConfig.sortSettings) !== null && _this$aggConfig$sortS !== void 0 ? _this$aggConfig$sortS : {};
      if ((0, _pivot_aggs.isValidSortDirection)(sortDefinition)) {
        this.aggConfig.sortSettings.order = sortDefinition;
      }
      if ((0, _mlIsPopulatedObject.isPopulatedObject)(sortDefinition)) {
        const {
          order,
          mode,
          numeric_type: numType,
          ...rest
        } = sortDefinition;
        this.aggConfig.sortSettings = rest;
        if ((0, _pivot_aggs.isValidSortDirection)(order)) {
          this.aggConfig.sortSettings.order = order;
        }
        if ((0, _pivot_aggs.isValidSortMode)(mode)) {
          this.aggConfig.sortSettings.mode = mode;
        }
        if ((0, _pivot_aggs.isValidSortNumericType)(numType)) {
          this.aggConfig.sortSettings.numericType = numType;
        }
      }
      this.aggConfig = {
        ...this.aggConfig,
        ...(unsupportedConfig !== null && unsupportedConfig !== void 0 ? unsupportedConfig : {})
      };
    },
    isValid() {
      var _this$aggConfig$sortS2;
      return !!this.aggConfig.sortField && ((0, _pivot_aggs.isSpecialSortField)(this.aggConfig.sortField) ? true : !!((_this$aggConfig$sortS2 = this.aggConfig.sortSettings) !== null && _this$aggConfig$sortS2 !== void 0 && _this$aggConfig$sortS2.order));
    }
  };
}