"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.TelemetryPlugin = void 0;
var _defineProperty2 = _interopRequireDefault(require("@babel/runtime/helpers/defineProperty"));
var _browser = require("@elastic/ebt/shippers/elastic_v3/browser");
var _analyticsCollectionUtils = require("@kbn/analytics-collection-utils");
var _rxjs = require("rxjs");
var _ebt_v3_endpoint = require("../common/ebt_v3_endpoint");
var _routes = require("../common/routes");
var _services = require("./services");
var _render_welcome_telemetry_notice = require("./render_welcome_telemetry_notice");
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; } /*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the "Elastic License
 * 2.0", the "GNU Affero General Public License v3.0 only", and the "Server Side
 * Public License v 1"; you may not use this file except in compliance with, at
 * your election, the "Elastic License 2.0", the "GNU Affero General Public
 * License v3.0 only", or the "Server Side Public License, v 1".
 */
/**
 * Publicly exposed APIs from the Telemetry Service
 */

/**
 * Public's setup exposed APIs by the telemetry plugin
 */

/**
 * Public's start exposed APIs by the telemetry plugin
 */

/**
 * Public-exposed configuration
 */

function getTelemetryConstants(docLinks) {
  return {
    getPrivacyStatementUrl: () => docLinks.links.legal.privacyStatement
  };
}
class TelemetryPlugin {
  constructor(initializerContext) {
    (0, _defineProperty2.default)(this, "currentKibanaVersion", void 0);
    (0, _defineProperty2.default)(this, "config", void 0);
    (0, _defineProperty2.default)(this, "telemetryLabels$", void 0);
    (0, _defineProperty2.default)(this, "telemetrySender", void 0);
    (0, _defineProperty2.default)(this, "telemetryNotifications", void 0);
    (0, _defineProperty2.default)(this, "telemetryService", void 0);
    (0, _defineProperty2.default)(this, "canUserChangeSettings", true);
    this.currentKibanaVersion = initializerContext.env.packageInfo.version;
    this.config = initializerContext.config.get();
    this.telemetryLabels$ = new _rxjs.BehaviorSubject(this.config.labels);
  }
  setup(coreSetup, {
    screenshotMode,
    home
  }) {
    const {
      analytics,
      http,
      notifications,
      getStartServices
    } = coreSetup;
    const config = this.config;
    const currentKibanaVersion = this.currentKibanaVersion;
    this.telemetryService = new _services.TelemetryService({
      config,
      isScreenshotMode: this.shouldSkipTelemetry(screenshotMode),
      http,
      notifications,
      currentKibanaVersion
    });
    let telemetryConstants;
    getStartServices().then(([{
      docLinks
    }]) => {
      telemetryConstants = getTelemetryConstants(docLinks);
    });
    analytics.registerContextProvider({
      name: 'telemetry labels',
      context$: this.telemetryLabels$.pipe((0, _rxjs.tap)(labels => {
        var _window$elasticApm;
        // Hack to update the APM agent's labels.
        // In the future we might want to expose APM as a core service to make reporting metrics much easier.
        (_window$elasticApm = window.elasticApm) === null || _window$elasticApm === void 0 ? void 0 : _window$elasticApm.addLabels(labels);
      }), (0, _rxjs.map)(labels => ({
        labels
      }))),
      schema: {
        labels: {
          type: 'pass_through',
          _meta: {
            description: 'Custom labels added to the telemetry.labels config in the kibana.yml'
          }
        }
      }
    });
    const sendTo = this.getSendToEnv(config.sendUsageTo);
    analytics.registerShipper(_browser.ElasticV3BrowserShipper, {
      channelName: 'kibana-browser',
      version: currentKibanaVersion,
      buildShipperHeaders: _ebt_v3_endpoint.buildShipperHeaders,
      buildShipperUrl: (0, _ebt_v3_endpoint.createBuildShipperUrl)(sendTo)
    });
    if (config.localShipper) {
      // Make it async to exclude the shipper from the initial page load since this config will likely be false most of the time.
      Promise.resolve().then(() => _interopRequireWildcard(require('./local_shipper'))).then(({
        initializeLocalShipper
      }) => initializeLocalShipper(coreSetup)).catch(() => {});
    }
    this.telemetrySender = new _services.TelemetrySender(this.telemetryService, async () => {
      await this.refreshConfig(http);
      analytics.optIn({
        global: {
          enabled: this.telemetryService.isOptedIn && !this.shouldSkipTelemetry(screenshotMode)
        }
      });
    });
    if (home && !this.config.hidePrivacyStatement) {
      home.welcomeScreen.registerOnRendered(() => {
        var _this$telemetryServic;
        if ((_this$telemetryServic = this.telemetryService) !== null && _this$telemetryServic !== void 0 && _this$telemetryServic.userCanChangeSettings) {
          var _this$telemetryNotifi;
          (_this$telemetryNotifi = this.telemetryNotifications) === null || _this$telemetryNotifi === void 0 ? void 0 : _this$telemetryNotifi.setOptInStatusNoticeSeen();
        }
      });
      home.welcomeScreen.registerTelemetryNoticeRenderer(() => (0, _render_welcome_telemetry_notice.renderWelcomeTelemetryNotice)(this.telemetryService, http.basePath.prepend, telemetryConstants));
    }
    return {
      telemetryService: this.getTelemetryServicePublicApis()
    };
  }
  start({
    analytics,
    http,
    overlays,
    application,
    docLinks,
    ...startServices
  }, {
    screenshotMode
  }) {
    if (!this.telemetryService) {
      throw Error('Telemetry plugin failed to initialize properly.');
    }
    this.canUserChangeSettings = this.getCanUserChangeSettings(application);
    this.telemetryService.userCanChangeSettings = this.canUserChangeSettings;
    const telemetryConstants = getTelemetryConstants(docLinks);
    const telemetryNotifications = new _services.TelemetryNotifications({
      http,
      overlays,
      telemetryService: this.telemetryService,
      telemetryConstants,
      analytics,
      ...startServices
    });
    this.telemetryNotifications = telemetryNotifications;
    application.currentAppId$.pipe((0, _rxjs.switchMap)(async () => {
      // Disable telemetry and terminate early if Kibana is running in a special "skip" mode
      if (this.shouldSkipTelemetry(screenshotMode)) {
        analytics.optIn({
          global: {
            enabled: false
          }
        });
        return;
      }

      // Refresh and get telemetry config
      const updatedConfig = await this.refreshConfig(http);
      analytics.optIn({
        global: {
          enabled: this.telemetryService.isOptedIn
        }
      });
      const isUnauthenticated = this.getIsUnauthenticated(http);
      if (isUnauthenticated) {
        return;
      }
      const telemetryBanner = updatedConfig === null || updatedConfig === void 0 ? void 0 : updatedConfig.banner;
      this.maybeStartTelemetryPoller();
      if (telemetryBanner) {
        this.maybeShowOptedInNotificationBanner();
      }
    })).subscribe();
    return {
      telemetryService: this.getTelemetryServicePublicApis(),
      telemetryNotifications: {
        setOptedInNoticeSeen: () => telemetryNotifications.setOptInStatusNoticeSeen()
      },
      telemetryConstants
    };
  }
  stop() {
    var _this$telemetrySender;
    (_this$telemetrySender = this.telemetrySender) === null || _this$telemetrySender === void 0 ? void 0 : _this$telemetrySender.stop();
  }
  getSendToEnv(sendUsageTo) {
    return sendUsageTo === 'prod' ? 'production' : 'staging';
  }

  /**
   * Kibana should skip telemetry collection if reporting is taking a screenshot
   * or Synthetics monitoring is navigating Kibana.
   * @param screenshotMode {@link ScreenshotModePluginSetup}
   * @internal
   */
  shouldSkipTelemetry(screenshotMode) {
    return screenshotMode.isScreenshotMode() || (0, _analyticsCollectionUtils.isSyntheticsMonitor)();
  }
  getTelemetryServicePublicApis() {
    const telemetryService = this.telemetryService;
    return {
      getIsOptedIn: () => telemetryService.getIsOptedIn(),
      setOptIn: optedIn => telemetryService.setOptIn(optedIn),
      canSendTelemetry: () => telemetryService.canSendTelemetry(),
      userCanChangeSettings: telemetryService.userCanChangeSettings,
      getCanChangeOptInStatus: () => telemetryService.getCanChangeOptInStatus(),
      fetchExample: () => telemetryService.fetchExample()
    };
  }

  /**
   * Retrieve the up-to-date configuration
   * @param http HTTP helper to make requests to the server
   * @internal
   */
  async refreshConfig(http) {
    const updatedConfig = await this.fetchUpdatedConfig(http);
    if (this.telemetryService) {
      this.telemetryService.config = updatedConfig;
    }
    this.telemetryLabels$.next(updatedConfig.labels);
    return updatedConfig;
  }

  /**
   * Can the user edit the saved objects?
   * This is a security feature, not included in the OSS build, so we need to fallback to `true`
   * in case it is `undefined`.
   * @param application CoreStart.application
   * @internal
   */
  getCanUserChangeSettings(application) {
    var _ref, _application$capabili, _application$capabili2;
    return (_ref = (_application$capabili = application.capabilities) === null || _application$capabili === void 0 ? void 0 : (_application$capabili2 = _application$capabili.savedObjectsManagement) === null || _application$capabili2 === void 0 ? void 0 : _application$capabili2.edit) !== null && _ref !== void 0 ? _ref : true;
  }
  getIsUnauthenticated(http) {
    const {
      anonymousPaths
    } = http;
    return anonymousPaths.isAnonymous(window.location.pathname);
  }
  maybeStartTelemetryPoller() {
    if (!this.telemetrySender) {
      return;
    }
    this.telemetrySender.startChecking();
  }
  maybeShowOptedInNotificationBanner() {
    if (!this.telemetryNotifications) {
      return;
    }
    const shouldShowBanner = this.telemetryNotifications.shouldShowOptInStatusNoticeBanner();
    if (shouldShowBanner) {
      this.telemetryNotifications.renderOptInStatusNoticeBanner();
    }
  }

  /**
   * Fetch configuration from the server and merge it with the one the browser already knows
   * @param http The HTTP helper to make the requests
   * @internal
   */
  async fetchUpdatedConfig(http) {
    const {
      allowChangingOptInStatus,
      optIn,
      sendUsageFrom,
      telemetryNotifyUserAboutOptInDefault,
      labels
    } = await http.get(_routes.FetchTelemetryConfigRoute, _routes.INTERNAL_VERSION);
    return {
      ...this.config,
      allowChangingOptInStatus,
      optIn,
      sendUsageFrom,
      telemetryNotifyUserAboutOptInDefault,
      labels,
      userCanChangeSettings: this.canUserChangeSettings
    };
  }
}
exports.TelemetryPlugin = TelemetryPlugin;