"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.MsearchError = void 0;
exports.getMsearchStatusCode = getMsearchStatusCode;
var _defineProperty2 = _interopRequireDefault(require("@babel/runtime/helpers/defineProperty"));
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

class MsearchError extends Error {
  constructor(statusCode) {
    super(`Unexpected status code from taskStore::msearch: ${statusCode !== null && statusCode !== void 0 ? statusCode : 'unknown'}`);
    (0, _defineProperty2.default)(this, "_statusCode", void 0);
    this._statusCode = statusCode;
  }
  get statusCode() {
    return this._statusCode;
  }
}
exports.MsearchError = MsearchError;
function getMsearchStatusCode(error) {
  if (Boolean(error && error instanceof MsearchError)) {
    return error.statusCode;
  }
}