"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.migration890 = void 0;
var _legacy_synthetics_monitor = require("../../synthetics_monitor/legacy_synthetics_monitor");
var _runtime_types = require("../../../../common/runtime_types");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const migration890 = encryptedSavedObjects => {
  return encryptedSavedObjects.createMigration({
    isMigrationNeededPredicate: function shouldBeMigrated(doc) {
      return true;
    },
    migration: doc => {
      var _migrated$attributes$;
      let migrated = doc;
      migrated = {
        ...migrated,
        attributes: {
          ...migrated.attributes,
          [_runtime_types.ConfigKey.ALERT_CONFIG]: {
            status: {
              enabled: true
            },
            tls: {
              enabled: true
            },
            ...((_migrated$attributes$ = migrated.attributes[_runtime_types.ConfigKey.ALERT_CONFIG]) !== null && _migrated$attributes$ !== void 0 ? _migrated$attributes$ : {})
          },
          // when any action to change a project monitor configuration is taken
          // outside the synthetics agent cli, we should set the config hash back
          // to an empty string so that the project monitors configuration
          // will be updated on next push
          [_runtime_types.ConfigKey.CONFIG_HASH]: ''
        }
      };
      return migrated;
    },
    inputType: _legacy_synthetics_monitor.LEGACY_SYNTHETICS_MONITOR_ENCRYPTED_TYPE_SINGLE,
    migratedType: _legacy_synthetics_monitor.LEGACY_SYNTHETICS_MONITOR_ENCRYPTED_TYPE_SINGLE
  });
};
exports.migration890 = migration890;