"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.updatePrivateLocationMonitors = exports.toSavedObjectContract = exports.toClientContract = exports.allLocationsToClientContract = void 0;
var _utils = require("../../../synthetics_service/utils");
var _edit_monitor_bulk = require("../../monitor_cruds/bulk_cruds/edit_monitor_bulk");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const toClientContract = locationObject => {
  const location = locationObject.attributes;
  return {
    label: location.label,
    id: location.id,
    agentPolicyId: location.agentPolicyId,
    isServiceManaged: false,
    isInvalid: false,
    tags: location.tags,
    geo: location.geo,
    spaces: locationObject.namespaces
  };
};
exports.toClientContract = toClientContract;
const allLocationsToClientContract = (attributes, agentPolicies) => {
  return attributes.locations.map(location => {
    const agPolicy = agentPolicies === null || agentPolicies === void 0 ? void 0 : agentPolicies.find(policy => policy.id === location.agentPolicyId);
    return {
      label: location.label,
      id: location.id,
      agentPolicyId: location.agentPolicyId,
      isServiceManaged: false,
      isInvalid: !Boolean(agPolicy),
      tags: location.tags,
      geo: location.geo,
      spaces: location.spaces
    };
  });
};
exports.allLocationsToClientContract = allLocationsToClientContract;
const toSavedObjectContract = location => {
  return {
    label: location.label,
    id: location.id,
    agentPolicyId: location.agentPolicyId,
    tags: location.tags,
    isServiceManaged: false,
    geo: location.geo,
    namespace: location.namespace,
    spaces: location.spaces
  };
};

// This should be called when changing the label of a private location because the label is also stored
// in the locations array of monitors attributes
exports.toSavedObjectContract = toSavedObjectContract;
const updatePrivateLocationMonitors = async ({
  locationId,
  newLocationLabel,
  allPrivateLocations,
  routeContext,
  monitorsInLocation
}) => {
  const updatedMonitorsPerSpace = monitorsInLocation.reduce((acc, m) => {
    var _m$namespaces;
    const decryptedMonitorsWithNormalizedSecrets = (0, _utils.normalizeSecrets)(m);
    const normalizedMonitor = decryptedMonitorsWithNormalizedSecrets.attributes;
    const newLocations = m.attributes.locations.map(l => l.id !== locationId ? l : {
      ...l,
      label: newLocationLabel
    });
    const monitorWithRevision = (0, _utils.formatSecrets)({
      ...normalizedMonitor,
      locations: newLocations
    });
    const monitorToUpdate = {
      normalizedMonitor,
      decryptedPreviousMonitor: m,
      monitorWithRevision
    };
    const spaceId = ((_m$namespaces = m.namespaces) === null || _m$namespaces === void 0 ? void 0 : _m$namespaces[0]) || 'default'; // Default to 'default' if no namespace is found
    return {
      ...acc,
      [spaceId]: [...(acc[spaceId] || []), monitorToUpdate]
    };
  }, {});
  const promises = Object.keys(updatedMonitorsPerSpace).map(spaceId => [(0, _edit_monitor_bulk.syncEditedMonitorBulk)({
    monitorsToUpdate: updatedMonitorsPerSpace[spaceId],
    privateLocations: allPrivateLocations,
    routeContext,
    spaceId
  })]);
  return Promise.all(promises.flat());
};
exports.updatePrivateLocationMonitors = updatePrivateLocationMonitors;