"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.syntheticsGetPingHeatmapRoute = void 0;
var _configSchema = require("@kbn/config-schema");
var _constants = require("../../../common/constants");
var _monitor_status_heatmap = require("../../common/pings/monitor_status_heatmap");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const syntheticsGetPingHeatmapRoute = () => ({
  method: 'GET',
  path: _constants.SYNTHETICS_API_URLS.MONITOR_STATUS_HEATMAP,
  validate: {
    query: _configSchema.schema.object({
      from: _configSchema.schema.maybe(_configSchema.schema.oneOf([_configSchema.schema.number(), _configSchema.schema.string()])),
      to: _configSchema.schema.maybe(_configSchema.schema.oneOf([_configSchema.schema.number(), _configSchema.schema.string()])),
      interval: _configSchema.schema.number(),
      monitorId: _configSchema.schema.string(),
      location: _configSchema.schema.string()
    })
  },
  handler: async ({
    syntheticsEsClient,
    request
  }) => {
    var _result$body$aggregat, _result$body$aggregat2;
    const {
      from,
      to,
      interval: intervalInMinutes,
      monitorId,
      location
    } = request.query;
    const result = await (0, _monitor_status_heatmap.queryMonitorHeatmap)({
      syntheticsEsClient,
      from,
      to,
      monitorId,
      location,
      intervalInMinutes
    });
    return {
      result: (_result$body$aggregat = result.body.aggregations) === null || _result$body$aggregat === void 0 ? void 0 : (_result$body$aggregat2 = _result$body$aggregat.heatmap) === null || _result$body$aggregat2 === void 0 ? void 0 : _result$body$aggregat2.buckets
    };
  }
});
exports.syntheticsGetPingHeatmapRoute = syntheticsGetPingHeatmapRoute;