"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.mapSavedObjectToMonitor = mapSavedObjectToMonitor;
exports.mergeSourceMonitor = mergeSourceMonitor;
exports.transformPublicKeys = exports.removeMonitorEmptyValues = void 0;
var _lodash = require("lodash");
var _runtime_types = require("../../../../common/runtime_types");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const keysToOmit = [_runtime_types.ConfigKey.URLS, _runtime_types.ConfigKey.SOURCE_INLINE, _runtime_types.ConfigKey.HOSTS, _runtime_types.ConfigKey.CONFIG_HASH, _runtime_types.ConfigKey.JOURNEY_ID, _runtime_types.ConfigKey.FORM_MONITOR_TYPE];
const transformPublicKeys = result => {
  var _result$ConfigKey$MAX;
  if (result[_runtime_types.ConfigKey.SOURCE_INLINE]) {
    result.inline_script = result[_runtime_types.ConfigKey.SOURCE_INLINE];
  }
  if (result[_runtime_types.ConfigKey.HOSTS]) {
    result.host = result[_runtime_types.ConfigKey.HOSTS];
  }
  if (result[_runtime_types.ConfigKey.PARAMS]) {
    try {
      var _result$ConfigKey$PAR;
      result[_runtime_types.ConfigKey.PARAMS] = JSON.parse((_result$ConfigKey$PAR = result[_runtime_types.ConfigKey.PARAMS]) !== null && _result$ConfigKey$PAR !== void 0 ? _result$ConfigKey$PAR : '{}');
    } catch (e) {
      // ignore
    }
  }
  let formattedResult = {
    ...result,
    [_runtime_types.ConfigKey.PARAMS]: formatParams(result),
    retest_on_failure: ((_result$ConfigKey$MAX = result[_runtime_types.ConfigKey.MAX_ATTEMPTS]) !== null && _result$ConfigKey$MAX !== void 0 ? _result$ConfigKey$MAX : 1) > 1,
    ...(result[_runtime_types.ConfigKey.HOSTS] && {
      host: result[_runtime_types.ConfigKey.HOSTS]
    }),
    ...(result[_runtime_types.ConfigKey.URLS] && {
      url: result[_runtime_types.ConfigKey.URLS]
    })
  };
  if (formattedResult[_runtime_types.ConfigKey.MONITOR_TYPE] === 'browser') {
    formattedResult = {
      ...formattedResult,
      ...(result[_runtime_types.ConfigKey.SOURCE_INLINE] && {
        inline_script: result[_runtime_types.ConfigKey.SOURCE_INLINE]
      }),
      [_runtime_types.ConfigKey.PLAYWRIGHT_OPTIONS]: formatPWOptions(result)
    };
  }
  return (0, _lodash.omit)(formattedResult, keysToOmit);
};
exports.transformPublicKeys = transformPublicKeys;
function mapSavedObjectToMonitor({
  monitor,
  internal = false
}) {
  let result = {
    ...monitor.attributes,
    created_at: monitor.created_at,
    updated_at: monitor.updated_at
  };
  if (internal) {
    return result;
  }
  result = transformPublicKeys(result);
  // omit undefined value or null value
  return (0, _lodash.omitBy)(result, removeMonitorEmptyValues);
}
function mergeSourceMonitor(normalizedPreviousMonitor, monitor) {
  return (0, _lodash.mergeWith)({
    ...normalizedPreviousMonitor
  }, monitor, customizer);
}

// Ensure that METADATA is merged deeply, to protect AAD and prevent decryption errors
const customizer = (destVal, srcValue, key) => {
  if (key === _runtime_types.ConfigKey.ALERT_CONFIG) {
    return {
      ...destVal,
      ...srcValue
    };
  }
  if (key !== _runtime_types.ConfigKey.METADATA) {
    return srcValue;
  }
};
const formatParams = config => {
  if (config[_runtime_types.ConfigKey.PARAMS]) {
    try {
      var _config$ConfigKey$PAR;
      return config[_runtime_types.ConfigKey.PARAMS] = JSON.parse((_config$ConfigKey$PAR = config[_runtime_types.ConfigKey.PARAMS]) !== null && _config$ConfigKey$PAR !== void 0 ? _config$ConfigKey$PAR : '{}');
    } catch (e) {
      // ignore
      return {};
    }
  }
  return {};
};
const formatPWOptions = config => {
  if (config[_runtime_types.ConfigKey.PLAYWRIGHT_OPTIONS]) {
    try {
      var _config$ConfigKey$PLA;
      return config[_runtime_types.ConfigKey.PLAYWRIGHT_OPTIONS] = JSON.parse((_config$ConfigKey$PLA = config[_runtime_types.ConfigKey.PLAYWRIGHT_OPTIONS]) !== null && _config$ConfigKey$PLA !== void 0 ? _config$ConfigKey$PLA : '{}');
    } catch (e) {
      // ignore
      return {};
    }
  }
  return {};
};

// combine same nested fields into same object
const formatNestedFields = (config, nestedKey) => {
  const nestedFields = Object.keys(config).filter(key => key.startsWith(`${nestedKey}.`));
  const obj = {};
  nestedFields.forEach(key => {
    const newKey = key.replace(`${nestedKey}.`, '');
    obj[newKey] = config[key];
    delete config[key];
  });
  if (nestedKey === 'check') {
    return {
      request: formatNestedFields(obj, 'request'),
      response: formatNestedFields(obj, 'response')
    };
  }
  return obj;
};
const removeMonitorEmptyValues = v => {
  // value is falsy
  return v === undefined || v === null ||
  // value is empty string
  typeof v === 'string' && v.trim() === '' ||
  // is empty array
  Array.isArray(v) && v.length === 0 ||
  // object is has no values
  typeof v === 'object' && Object.keys(v).length === 0;
};
exports.removeMonitorEmptyValues = removeMonitorEmptyValues;