"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.useSettingsBreadcrumbs = void 0;
var _i18n = require("@kbn/i18n");
var _public = require("@kbn/kibana-react-plugin/public");
var _plugin = require("../../../../../common/constants/plugin");
var _constants = require("../../../../../common/constants");
var _hooks = require("../../hooks");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const useSettingsBreadcrumbs = extraCrumbs => {
  var _kibana$services$appl, _kibana$services$appl2;
  const kibana = (0, _public.useKibana)();
  const appPath = (_kibana$services$appl = (_kibana$services$appl2 = kibana.services.application) === null || _kibana$services$appl2 === void 0 ? void 0 : _kibana$services$appl2.getUrlForApp(_plugin.PLUGIN.SYNTHETICS_PLUGIN_ID)) !== null && _kibana$services$appl !== void 0 ? _kibana$services$appl : '';
  (0, _hooks.useBreadcrumbs)([{
    text: MONITOR_MANAGEMENT_CRUMB,
    href: `${appPath}${_constants.SYNTHETICS_SETTINGS_ROUTE.replace(':tabId', 'alerting')}`
  }, ...(extraCrumbs !== null && extraCrumbs !== void 0 ? extraCrumbs : [])]);
};
exports.useSettingsBreadcrumbs = useSettingsBreadcrumbs;
const MONITOR_MANAGEMENT_CRUMB = _i18n.i18n.translate('xpack.synthetics.settings.title', {
  defaultMessage: 'Settings'
});