"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.AgentPolicyNeeded = void 0;
var _react = _interopRequireDefault(require("react"));
var _eui = require("@elastic/eui");
var _i18n = require("@kbn/i18n");
var _hooks = require("../../../hooks");
var _permissions = require("../../common/components/permissions");
var _contexts = require("../../../contexts");
var _empty_locations = require("./empty_locations");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const AgentPolicyNeeded = () => {
  const {
    basePath,
    canSave
  } = (0, _contexts.useSyntheticsSettingsContext)();
  const {
    canCreateAgentPolicies
  } = (0, _hooks.useFleetPermissions)();
  return /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, !canCreateAgentPolicies && /*#__PURE__*/_react.default.createElement(_permissions.FleetPermissionsCallout, null), /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, {
    size: "m"
  }), /*#__PURE__*/_react.default.createElement(_eui.EuiEmptyPrompt, {
    hasBorder: true,
    title: /*#__PURE__*/_react.default.createElement("h2", null, AGENT_POLICY_NEEDED),
    body: /*#__PURE__*/_react.default.createElement("p", null, ADD_AGENT_POLICY_DESCRIPTION),
    actions: /*#__PURE__*/_react.default.createElement(_permissions.NoPermissionsTooltip, {
      canEditSynthetics: canSave
    }, /*#__PURE__*/_react.default.createElement(_eui.EuiButton, {
      "data-test-subj": "syntheticsAgentPolicyNeededButton",
      fill: true,
      href: `${basePath}/app/fleet/policies?create`,
      color: "primary",
      isDisabled: !canSave || !canCreateAgentPolicies
    }, CREATE_AGENT_POLICY)),
    footer: /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, /*#__PURE__*/_react.default.createElement(_eui.EuiTitle, {
      size: "xxs"
    }, /*#__PURE__*/_react.default.createElement("h3", null, _empty_locations.LEARN_MORE)), /*#__PURE__*/_react.default.createElement(_eui.EuiLink, {
      "data-test-subj": "syntheticsAgentPolicyNeededLink",
      target: "_blank",
      href: "https://www.elastic.co/guide/en/observability/current/uptime-set-up-choose-agent.html#private-locations"
    }, _empty_locations.READ_DOCS))
  }));
};
exports.AgentPolicyNeeded = AgentPolicyNeeded;
const CREATE_AGENT_POLICY = _i18n.i18n.translate('xpack.synthetics.monitorManagement.createAgentPolicy', {
  defaultMessage: 'Create agent policy'
});
const AGENT_POLICY_NEEDED = _i18n.i18n.translate('xpack.synthetics.monitorManagement.agentPolicyNeeded', {
  defaultMessage: 'No agent policies found'
});
const ADD_AGENT_POLICY_DESCRIPTION = _i18n.i18n.translate('xpack.synthetics.monitorManagement.addAgentPolicyDesc', {
  defaultMessage: 'Private locations require an Agent policy. In order to add a private location, first you must create an Agent policy in Fleet.'
});