"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.MetricItemIcon = void 0;
var React = _interopRequireWildcard(require("react"));
var _eui = require("@elastic/eui");
var _reactRedux = require("react-redux");
var _styled = _interopRequireDefault(require("@emotion/styled"));
var _i18n = require("@kbn/i18n");
var _use_monitor_mws = require("../../../hooks/use_monitor_mws");
var _metric_error_icon = require("./metric_error_icon");
var _manual_test_runs = require("../../../../../state/manual_test_runs");
var _state = require("../../../../../state");
var _error_details_link = require("../../../../common/links/error_details_link");
var _use_date_format = require("../../../../../../../hooks/use_date_format");
var _use_latest_error = require("./use_latest_error");
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const Container = _styled.default.div`
  display: inline-block;
  position: absolute;
  right: 10px;
  top: 10px;
  z-index: 1;
`;
const MetricItemIcon = ({
  monitor,
  status,
  timestamp,
  configIdByLocation
}) => {
  var _latestPing$state;
  const testNowRun = (0, _reactRedux.useSelector)((0, _manual_test_runs.manualTestRunSelector)(monitor.configId));
  const isPopoverOpen = (0, _reactRedux.useSelector)(_state.selectErrorPopoverState);
  const {
    latestPing
  } = (0, _use_latest_error.useLatestError)({
    configIdByLocation,
    monitorId: monitor.configId,
    locationLabel: monitor.locationLabel
  });
  const dispatch = (0, _reactRedux.useDispatch)();
  const {
    activeMWs
  } = (0, _use_monitor_mws.useMonitorMWs)(monitor);
  const inProgress = (0, _manual_test_runs.isTestRunning)(testNowRun);
  const errorLink = (0, _error_details_link.useErrorDetailsLink)({
    configId: monitor.configId,
    stateId: latestPing === null || latestPing === void 0 ? void 0 : (_latestPing$state = latestPing.state) === null || _latestPing$state === void 0 ? void 0 : _latestPing$state.id,
    locationId: monitor.locationId
  });
  const formatter = (0, _use_date_format.useDateFormat)();
  const testTime = formatter(timestamp);
  if (inProgress) {
    return /*#__PURE__*/React.createElement(Container, null, /*#__PURE__*/React.createElement(_eui.EuiToolTip, {
      position: "top",
      content: TEST_IN_PROGRESS
    }, /*#__PURE__*/React.createElement(_eui.EuiLoadingSpinner, null)));
  }
  if (activeMWs.length) {
    return /*#__PURE__*/React.createElement(Container, null, /*#__PURE__*/React.createElement(_eui.EuiIconTip, {
      content: _i18n.i18n.translate('xpack.synthetics.metricItemIcon.euiButtonIcon.maintenanceWindowActive', {
        defaultMessage: 'Monitor is stopped while maintenance windows are running.'
      }),
      type: "pause",
      color: "warning",
      iconProps: {
        'data-test-subj': 'syntheticsMetricItemIconButton'
      }
    }));
  }
  const closePopover = () => {
    dispatch((0, _state.toggleErrorPopoverOpen)(null));
  };
  if (status === 'down') {
    var _latestPing$url, _latestPing$error, _latestPing$error2;
    return /*#__PURE__*/React.createElement(Container, null, /*#__PURE__*/React.createElement(_eui.EuiPopover, {
      button: /*#__PURE__*/React.createElement(_metric_error_icon.MetricErrorIcon, {
        configIdByLocation: configIdByLocation
      }),
      isOpen: configIdByLocation === isPopoverOpen,
      closePopover: closePopover,
      anchorPosition: "upCenter",
      panelStyle: {
        outline: 'none'
      }
    }, /*#__PURE__*/React.createElement(_eui.EuiPopoverTitle, null, /*#__PURE__*/React.createElement(_eui.EuiFlexGroup, null, /*#__PURE__*/React.createElement(_eui.EuiFlexItem, {
      grow: true
    }, testTime), /*#__PURE__*/React.createElement(_eui.EuiFlexItem, {
      grow: false
    }, /*#__PURE__*/React.createElement(_eui.EuiButtonIcon, {
      "data-test-subj": "syntheticsMetricItemIconButton",
      iconType: "cross",
      onClick: closePopover,
      "aria-label": _i18n.i18n.translate('xpack.synthetics.metricItemIcon.euiButtonIcon.closePopover', {
        defaultMessage: 'Close popover'
      })
    })))), /*#__PURE__*/React.createElement("div", {
      style: {
        width: '300px',
        overflowWrap: 'break-word'
      }
    }, (latestPing === null || latestPing === void 0 ? void 0 : (_latestPing$url = latestPing.url) === null || _latestPing$url === void 0 ? void 0 : _latestPing$url.full) && /*#__PURE__*/React.createElement(React.Fragment, null, _i18n.i18n.translate('xpack.synthetics.metricItemIcon.div.urlLabel', {
      defaultMessage: 'URL: '
    }), /*#__PURE__*/React.createElement(_eui.EuiLink, {
      "data-test-subj": "syntheticsMetricItemIconLink",
      href: latestPing.url.full,
      target: "_blank"
    }, latestPing.url.full), /*#__PURE__*/React.createElement(_eui.EuiSpacer, {
      size: "s"
    })), /*#__PURE__*/React.createElement(_eui.EuiCallOut, {
      title: latestPing !== null && latestPing !== void 0 && (_latestPing$error = latestPing.error) !== null && _latestPing$error !== void 0 && _latestPing$error.message ? latestPing === null || latestPing === void 0 ? void 0 : (_latestPing$error2 = latestPing.error) === null || _latestPing$error2 === void 0 ? void 0 : _latestPing$error2.message : /*#__PURE__*/React.createElement(_eui.EuiSkeletonText, {
        lines: 2
      }),
      color: "danger",
      iconType: "warning"
    })), /*#__PURE__*/React.createElement(_eui.EuiPopoverFooter, null, /*#__PURE__*/React.createElement(_eui.EuiButton, {
      "data-test-subj": "syntheticsMetricItemIconButton",
      fullWidth: true,
      size: "s",
      href: errorLink
    }, ERROR_DETAILS))));
  } else {
    if (latestPing !== null && latestPing !== void 0 && latestPing.url) {
      return /*#__PURE__*/React.createElement(Container, null, /*#__PURE__*/React.createElement(_eui.EuiButtonIcon, {
        title: latestPing.url.full,
        color: "text",
        "data-test-subj": "syntheticsMetricItemIconButton",
        href: latestPing.url.full,
        iconType: "link",
        target: "_blank",
        "aria-label": _i18n.i18n.translate('xpack.synthetics.metricItemIcon.euiButtonIcon.monitorUrl', {
          defaultMessage: 'Monitor url'
        })
      }));
    }
    return null;
  }
};
exports.MetricItemIcon = MetricItemIcon;
const ERROR_DETAILS = _i18n.i18n.translate('xpack.synthetics.errorDetails.label', {
  defaultMessage: 'Error details'
});
const TEST_IN_PROGRESS = _i18n.i18n.translate('xpack.synthetics.inProgress.label', {
  defaultMessage: 'Manual test run is in progress.'
});