"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.useMonitorHistogram = void 0;
var _public = require("@kbn/observability-shared-plugin/public");
var _get_histogram_interval = require("../common/get_histogram_interval");
var _constants = require("../../../../../../common/constants");
var _hooks = require("../../../hooks");
var _contexts = require("../../../contexts");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const useMonitorHistogram = ({
  items
}) => {
  var _data$aggregations$by, _data$aggregations;
  const {
    dateRangeStart,
    dateRangeEnd
  } = (0, _hooks.useGetUrlParams)();
  const {
    lastRefresh
  } = (0, _contexts.useSyntheticsRefreshContext)();
  const monitorIds = (items !== null && items !== void 0 ? items : []).map(({
    configId
  }) => configId);
  const {
    queryParams,
    minInterval
  } = getQueryParams(dateRangeStart, dateRangeEnd, monitorIds, _constants.SYNTHETICS_INDEX_PATTERN);
  const {
    data,
    loading
  } = (0, _public.useEsSearch)(queryParams, [JSON.stringify(monitorIds), lastRefresh], {
    name: 'getMonitorDownHistory'
  });
  const byIdsBuckets = (_data$aggregations$by = data === null || data === void 0 ? void 0 : (_data$aggregations = data.aggregations) === null || _data$aggregations === void 0 ? void 0 : _data$aggregations.byIds.buckets) !== null && _data$aggregations$by !== void 0 ? _data$aggregations$by : [];
  const histogramsById = {};
  byIdsBuckets.forEach(idBucket => {
    idBucket.perLocation.buckets.forEach(locationBucket => {
      const uniqId = `${idBucket.key}-${locationBucket.key}`;
      const points = [];
      locationBucket.histogram.buckets.forEach(histogramBucket => {
        var _histogramBucket$tota;
        const timestamp = histogramBucket.key;
        const down = (_histogramBucket$tota = histogramBucket.totalDown.value) !== null && _histogramBucket$tota !== void 0 ? _histogramBucket$tota : 0;
        points.push({
          timestamp,
          up: undefined,
          down
        });
      });
      histogramsById[uniqId] = {
        points
      };
    });
  });
  return {
    histogramsById,
    loading,
    minInterval
  };
};
exports.useMonitorHistogram = useMonitorHistogram;
const getQueryParams = (dateRangeStart, dateRangeEnd, configIds, index) => {
  const minInterval = (0, _get_histogram_interval.getHistogramInterval)(dateRangeStart, dateRangeEnd, 30);
  const queryParams = {
    index,
    size: 0,
    query: {
      bool: {
        filter: [{
          range: {
            'summary.down': {
              gt: 0
            }
          }
        }, {
          terms: {
            config_id: configIds
          }
        }, {
          range: {
            '@timestamp': {
              gte: dateRangeStart,
              lte: dateRangeEnd
            }
          }
        }]
      }
    },
    aggs: {
      byIds: {
        terms: {
          field: 'monitor.id',
          size: Math.max(configIds.length, 1)
        },
        aggs: {
          perLocation: {
            terms: {
              field: 'observer.name'
            },
            aggs: {
              histogram: {
                date_histogram: {
                  field: '@timestamp',
                  fixed_interval: minInterval + 'ms'
                },
                aggs: {
                  totalDown: {
                    sum: {
                      field: 'summary.down'
                    }
                  }
                }
              }
            }
          }
        }
      }
    }
  };
  return {
    queryParams,
    minInterval
  };
};