"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.internalEsqlRoutes = exports.executeEsqlRoute = void 0;
var _tracedEsClient = require("@kbn/traced-es-client");
var _zod = require("@kbn/zod");
var _lodash = require("lodash");
var _constants = require("../../../../common/constants");
var _create_server_route = require("../../create_server_route");
var _query_helpers = require("./query_helpers");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const executeEsqlRoute = exports.executeEsqlRoute = (0, _create_server_route.createServerRoute)({
  endpoint: 'POST /internal/streams/esql',
  options: {
    access: 'internal'
  },
  security: {
    authz: {
      requiredPrivileges: [_constants.STREAMS_API_PRIVILEGES.read]
    }
  },
  params: _zod.z.object({
    body: _zod.z.object({
      query: _zod.z.string(),
      operationName: _zod.z.string(),
      filter: _zod.z.object({}).passthrough().optional(),
      kuery: _zod.z.string().optional(),
      start: _zod.z.number().optional(),
      end: _zod.z.number().optional()
    })
  }),
  handler: async ({
    params,
    request,
    logger,
    getScopedClients
  }) => {
    const {
      scopedClusterClient
    } = await getScopedClients({
      request
    });
    const tracedEsClient = (0, _tracedEsClient.createTracedEsClient)({
      client: scopedClusterClient.asCurrentUser,
      logger,
      plugin: 'streams'
    });
    const {
      body: {
        operationName,
        query,
        filter,
        kuery,
        start,
        end
      }
    } = params;
    const response = await tracedEsClient.esql(operationName, {
      query,
      filter: {
        bool: {
          filter: [filter || {
            match_all: {}
          }, ...(0, _query_helpers.kqlQuery)(kuery), ...(0, _query_helpers.excludeFrozenQuery)(), ...((0, _lodash.isNumber)(start) && (0, _lodash.isNumber)(end) ? (0, _query_helpers.rangeQuery)(start, end) : [])]
        }
      }
    }, {
      transform: 'none'
    });
    return response;
  }
});
const internalEsqlRoutes = exports.internalEsqlRoutes = {
  ...executeEsqlRoute
};