"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.executeEsqlRequest = void 0;
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const executeEsqlRequest = async ({
  esClient,
  esqlRequest,
  logger
}) => {
  try {
    const response = await esClient.esql.query({
      query: esqlRequest.query,
      filter: esqlRequest.filter,
      drop_null_columns: true
    });
    const {
      columns,
      values
    } = response;
    const [sourceIndex, idIndex] = [columns.findIndex(col => col.name === '_source'), columns.findIndex(col => col.name === '_id')];
    if (sourceIndex === -1 || idIndex === -1) {
      throw new Error('Invalid ES|QL response format: missing _source or _id column');
    }
    const results = values.map(row => ({
      _id: row[idIndex],
      _source: row[sourceIndex]
    }));
    return results;
  } catch (error) {
    logger.debug(`Error executing ES|QL request: ${error.message}`);
    return [];
  }
};
exports.executeEsqlRequest = executeEsqlRequest;