"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.featureFlagUiSettings = void 0;
var _configSchema = require("@kbn/config-schema");
var _i18n = require("@kbn/i18n");
var _managementSettingsIds = require("@kbn/management-settings-ids");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const technicalPreviewLabel = _i18n.i18n.translate('xpack.streams.technicalPreviewSettingLabel', {
  defaultMessage: 'Technical Preview'
});
const featureFlagUiSettings = exports.featureFlagUiSettings = {
  [_managementSettingsIds.OBSERVABILITY_STREAMS_ENABLE_SIGNIFICANT_EVENTS]: {
    category: ['observability'],
    name: _i18n.i18n.translate('xpack.streams.significantEventsSettingsName', {
      defaultMessage: 'Streams significant events'
    }),
    value: false,
    description: _i18n.i18n.translate('xpack.streams.significantEventsSettingsDescription', {
      defaultMessage: '{technicalPreviewLabel} Enable streams significant events.',
      values: {
        technicalPreviewLabel: `<em>[${technicalPreviewLabel}]</em>`
      }
    }),
    type: 'boolean',
    schema: _configSchema.schema.boolean(),
    requiresPageReload: true,
    solution: 'oblt'
  }
};