"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.renderApp = exports.ObservabilityStreamsWrapperPlugin = void 0;
var _defineProperty2 = _interopRequireDefault(require("@babel/runtime/helpers/defineProperty"));
var _i18n = require("@kbn/i18n");
var _rxjs = require("rxjs");
var _public = require("@kbn/core/public");
var _constants = require("@kbn/deeplinks-observability/constants");
var _react = _interopRequireDefault(require("react"));
var _reactDom = _interopRequireDefault(require("react-dom"));
var _css = require("@emotion/css");
var _observability_streams_page_template = require("./observability_streams_page_template");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const renderApp = ({
  appMountParameters,
  StreamsApplicationComponent,
  observabilityShared,
  navigation
}) => {
  const {
    element
  } = appMountParameters;
  const appWrapperClassName = (0, _css.css)`
    overflow: auto;
  `;
  const appWrapperElement = document.getElementsByClassName(_public.APP_WRAPPER_CLASS)[1];
  appWrapperElement.classList.add(appWrapperClassName);
  _reactDom.default.render(/*#__PURE__*/_react.default.createElement(StreamsApplicationComponent, {
    appMountParameters: appMountParameters,
    PageTemplate: (0, _observability_streams_page_template.createObservabilityStreamsAppPageTemplate)({
      observabilityShared,
      navigation
    })
  }), element);
  return () => {
    _reactDom.default.unmountComponentAtNode(element);
    appWrapperElement.classList.remove(_public.APP_WRAPPER_CLASS);
  };
};
exports.renderApp = renderApp;
class ObservabilityStreamsWrapperPlugin {
  constructor(context) {
    (0, _defineProperty2.default)(this, "logger", void 0);
    this.logger = context.logger.get();
  }
  setup(coreSetup, pluginsSetup) {
    const startServicesPromise = coreSetup.getStartServices();
    pluginsSetup.observabilityShared.navigation.registerSections((0, _rxjs.from)(startServicesPromise).pipe((0, _rxjs.switchMap)(([_, pluginsStart]) => pluginsStart.streams.status$.pipe((0, _rxjs.map)(({
      status
    }) => {
      if (status !== 'enabled') {
        return [];
      }
      return [{
        label: '',
        sortKey: 101,
        entries: [{
          label: _i18n.i18n.translate('xpack.streams.streamsAppLinkTitle', {
            defaultMessage: 'Streams'
          }),
          app: _constants.STREAMS_APP_ID,
          path: '/',
          isTechnicalPreview: true,
          matchPath(currentPath) {
            return ['/', ''].some(testPath => currentPath.startsWith(testPath));
          }
        }]
      }];
    })))));
    coreSetup.application.register({
      id: _constants.STREAMS_APP_ID,
      title: _i18n.i18n.translate('xpack.streams.appTitle', {
        defaultMessage: 'Streams'
      }),
      euiIconType: 'logoObservability',
      appRoute: '/app/streams',
      category: _public.DEFAULT_APP_CATEGORIES.observability,
      order: 8001,
      updater$: (0, _rxjs.from)(startServicesPromise).pipe((0, _rxjs.switchMap)(([_, pluginsStart]) => pluginsStart.streams.status$.pipe((0, _rxjs.map)(({
        status
      }) => {
        return app => {
          if (status !== 'enabled') {
            return {
              visibleIn: []
            };
          }
          return {
            visibleIn: ['sideNav', 'globalSearch']
          };
        };
      })))),
      mount: async appMountParameters => {
        // Load application bundle and Get start services
        const [_, pluginsStart] = await coreSetup.getStartServices();
        const StreamsApplicationComponent = pluginsStart.streamsApp.createStreamsApplicationComponent();
        return renderApp({
          StreamsApplicationComponent,
          appMountParameters,
          observabilityShared: pluginsStart.observabilityShared,
          navigation: pluginsStart.navigation
        });
      }
    });
    return {};
  }
  start(coreStart, pluginsStart) {
    return {};
  }
}
exports.ObservabilityStreamsWrapperPlugin = ObservabilityStreamsWrapperPlugin;