"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.StreamsList = StreamsList;
exports.asTrees = asTrees;
var _eui = require("@elastic/eui");
var _i18n = require("@kbn/i18n");
var _react = _interopRequireWildcard(require("react"));
var _uiTheme = require("@kbn/ui-theme");
var _css = require("@emotion/css");
var _streamsSchema = require("@kbn/streams-schema");
var _use_streams_app_router = require("../../hooks/use_streams_app_router");
var _nested_view = require("../nested_view");
var _use_kibana = require("../../hooks/use_kibana");
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

function asTrees(streams) {
  const trees = [];
  const sortedStreams = streams.slice().sort((a, b) => (0, _streamsSchema.getSegments)(a.name).length - (0, _streamsSchema.getSegments)(b.name).length);
  sortedStreams.forEach(stream => {
    let currentTree = trees;
    let existingNode;
    // traverse the tree following the prefix of the current name.
    // once we reach the leaf, the current name is added as child - this works because the ids are sorted by depth
    while (existingNode = currentTree.find(node => (0, _streamsSchema.isDescendantOf)(node.name, stream.name))) {
      currentTree = existingNode.children;
    }
    if (!existingNode) {
      const newNode = {
        name: stream.name,
        children: [],
        stream,
        type: _streamsSchema.Streams.UnwiredStream.Definition.is(stream) ? 'classic' : (0, _streamsSchema.isRootStreamDefinition)(stream) ? 'root' : 'wired'
      };
      currentTree.push(newNode);
    }
  });
  return trees;
}
function StreamsList({
  streams,
  query,
  showControls
}) {
  const [collapsed, setCollapsed] = _react.default.useState({});
  const [showClassic, setShowClassic] = _react.default.useState(true);
  const items = (0, _react.useMemo)(() => {
    return streams !== null && streams !== void 0 ? streams : [];
  }, [streams]);
  const filteredItems = (0, _react.useMemo)(() => {
    return items.filter(item => showClassic || _streamsSchema.Streams.WiredStream.Definition.is(item)).filter(item => !query || item.name.toLowerCase().includes(query.toLowerCase()));
  }, [query, items, showClassic]);
  const treeView = (0, _react.useMemo)(() => asTrees(filteredItems), [filteredItems]);
  return /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
    direction: "column",
    gutterSize: "m"
  }, showControls && /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, /*#__PURE__*/_react.default.createElement(_eui.EuiTitle, {
    size: "xxs"
  }, /*#__PURE__*/_react.default.createElement("h2", null, _i18n.i18n.translate('xpack.streams.streamsTable.tableTitle', {
    defaultMessage: 'Streams'
  }))), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    grow: false
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
    gutterSize: "m",
    justifyContent: "spaceBetween"
  }, Object.keys(collapsed).length === 0 ? /*#__PURE__*/_react.default.createElement(_eui.EuiButtonEmpty, {
    "data-test-subj": "streamsAppStreamsListCollapseAllButton",
    iconType: "fold",
    size: "s",
    onClick: () => setCollapsed(Object.fromEntries(items.map(item => [item.name, true])))
  }, _i18n.i18n.translate('xpack.streams.streamsTable.collapseAll', {
    defaultMessage: 'Collapse all'
  })) : /*#__PURE__*/_react.default.createElement(_eui.EuiButtonEmpty, {
    "data-test-subj": "streamsAppStreamsListExpandAllButton",
    iconType: "unfold",
    onClick: () => setCollapsed({}),
    size: "s"
  }, _i18n.i18n.translate('xpack.streams.streamsTable.expandAll', {
    defaultMessage: 'Expand all'
  })), /*#__PURE__*/_react.default.createElement(_eui.EuiSwitch, {
    label: _i18n.i18n.translate('xpack.streams.streamsTable.showClassicStreams', {
      defaultMessage: 'Show classic streams'
    }),
    compressed: true,
    checked: showClassic,
    onChange: e => setShowClassic(e.target.checked)
  })))), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    grow: false
  }, treeView.map(tree => /*#__PURE__*/_react.default.createElement(StreamNode, {
    key: tree.name,
    node: tree,
    collapsed: collapsed,
    setCollapsed: setCollapsed
  }))));
}
function StreamNode({
  node,
  collapsed,
  setCollapsed
}) {
  const router = (0, _use_streams_app_router.useStreamsAppRouter)();
  const {
    dependencies: {
      start: {
        share
      }
    }
  } = (0, _use_kibana.useKibana)();
  const discoverLocator = (0, _react.useMemo)(() => share.url.locators.get('DISCOVER_APP_LOCATOR'), [share.url.locators]);
  const discoverUrl = (0, _react.useMemo)(() => {
    const indexPatterns = (0, _streamsSchema.getIndexPatternsForStream)(node.stream);
    if (!discoverLocator || !indexPatterns) {
      return undefined;
    }
    return discoverLocator.getRedirectUrl({
      query: {
        esql: `FROM ${indexPatterns.join(', ')}`
      }
    });
  }, [discoverLocator, node]);
  return /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
    direction: "column",
    gutterSize: "xs",
    className: (0, _css.css)`
        margin-top: ${_uiTheme.euiThemeVars.euiSizeXS};
        margin-left: ${_uiTheme.euiThemeVars.euiSizeS};
      `
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
    direction: "row",
    gutterSize: "s",
    alignItems: "center",
    className: (0, _css.css)`
          padding: ${_uiTheme.euiThemeVars.euiSizeXS};
          border-radius: ${_uiTheme.euiThemeVars.euiBorderRadius};
          &:hover {
            background-color: ${_uiTheme.euiThemeVars.euiColorLightestShade};
            .links {
              opacity: 1;
            }
          }
        `
  }, node.children.length > 0 &&
  /*#__PURE__*/
  // Using a regular button here instead of the EUI one to control styling
  _react.default.createElement("button", {
    type: "button",
    onClick: () => {
      setCollapsed === null || setCollapsed === void 0 ? void 0 : setCollapsed({
        ...collapsed,
        [node.name]: !(collapsed !== null && collapsed !== void 0 && collapsed[node.name])
      });
    },
    className: (0, _css.css)`
              background: none;
              margin-left: -${_uiTheme.euiThemeVars.euiSizeXS};
              margin-right: ${_uiTheme.euiThemeVars.euiSizeXS};
            `
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiIcon, {
    type: collapsed !== null && collapsed !== void 0 && collapsed[node.name] ? 'arrowRight' : 'arrowDown'
  })), /*#__PURE__*/_react.default.createElement(_eui.EuiLink, {
    "data-test-subj": "streamsAppStreamNodeLink",
    color: "text",
    href: router.link('/{key}', {
      path: {
        key: node.name
      }
    })
  }, node.name), node.type === 'root' && /*#__PURE__*/_react.default.createElement(_eui.EuiBadge, {
    color: "hollow"
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiIcon, {
    type: "branch",
    size: "s"
  })), node.type === 'classic' && /*#__PURE__*/_react.default.createElement(_eui.EuiBadge, {
    color: "hollow"
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiIcon, {
    type: "bullseye",
    size: "s"
  })), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
    className: `links ${(0, _css.css)`
            opacity: 0;
          `}`,
    alignItems: "center",
    gutterSize: "s"
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiToolTip, {
    content: _i18n.i18n.translate('xpack.streams.streamsTable.openInNewTab', {
      defaultMessage: 'Open in new tab'
    }),
    disableScreenReaderOutput: true
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiButtonIcon, {
    "data-test-subj": "streamsAppStreamNodeButton",
    "aria-label": _i18n.i18n.translate('xpack.streams.streamsTable.openInNewTab', {
      defaultMessage: 'Open in new tab'
    }),
    iconType: "popout",
    target: "_blank",
    href: router.link('/{key}', {
      path: {
        key: node.name
      }
    })
  })), /*#__PURE__*/_react.default.createElement(_eui.EuiToolTip, {
    content: _i18n.i18n.translate('xpack.streams.streamsTable.openInDiscover', {
      defaultMessage: 'Open in Discover'
    }),
    disableScreenReaderOutput: true
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiButtonIcon, {
    "data-test-subj": "streamsAppStreamNodeButton",
    iconType: "discoverApp",
    href: discoverUrl,
    "aria-label": _i18n.i18n.translate('xpack.streams.streamsTable.openInDiscover', {
      defaultMessage: 'Open in Discover'
    })
  })), /*#__PURE__*/_react.default.createElement(_eui.EuiToolTip, {
    content: _i18n.i18n.translate('xpack.streams.streamsTable.management', {
      defaultMessage: 'Management'
    }),
    disableScreenReaderOutput: true
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiButtonIcon, {
    "data-test-subj": "streamsAppStreamNodeButton",
    iconType: "gear",
    "aria-label": _i18n.i18n.translate('xpack.streams.streamsTable.management', {
      defaultMessage: 'Management'
    }),
    href: router.link('/{key}/management/{tab}', {
      path: {
        key: node.name,
        tab: 'route'
      }
    })
  })))), node.children.length > 0 && !(collapsed !== null && collapsed !== void 0 && collapsed[node.name]) && /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, null, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
    direction: "column",
    gutterSize: "xs"
  }, node.children.map((child, index) => /*#__PURE__*/_react.default.createElement(_nested_view.NestedView, {
    key: child.name,
    last: index === node.children.length - 1
  }, /*#__PURE__*/_react.default.createElement(StreamNode, {
    node: child,
    collapsed: collapsed,
    setCollapsed: setCollapsed
  }))))));
}