"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.useSignificantEventPreviewFetch = useSignificantEventPreviewFetch;
var _common = require("@kbn/data-plugin/common");
var _calculateAuto = require("@kbn/calculate-auto");
var _moment = _interopRequireDefault(require("moment"));
var _use_streams_app_fetch = require("../../../hooks/use_streams_app_fetch");
var _use_kibana = require("../../../hooks/use_kibana");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

function useSignificantEventPreviewFetch({
  name,
  queryValues,
  timeRange
}) {
  const {
    dependencies: {
      start: {
        streams
      }
    }
  } = (0, _use_kibana.useKibana)();
  const previewFetch = (0, _use_streams_app_fetch.useStreamsAppFetch)(({
    signal
  }) => {
    var _calculateAuto$near;
    const {
      kql
    } = queryValues;
    const {
      from,
      to
    } = (0, _common.getAbsoluteTimeRange)(timeRange);
    const bucketSize = (_calculateAuto$near = _calculateAuto.calculateAuto.near(50, _moment.default.duration((0, _moment.default)(to).diff(from)))) === null || _calculateAuto$near === void 0 ? void 0 : _calculateAuto$near.asSeconds();
    return streams.streamsRepositoryClient.fetch(`POST /api/streams/{name}/significant_events/_preview 2023-10-31`, {
      signal,
      params: {
        path: {
          name
        },
        query: {
          bucketSize: `${bucketSize}s`,
          from,
          to
        },
        body: {
          query: {
            kql: kql !== null && kql !== void 0 ? kql : {
              query: ''
            }
          }
        }
      }
    });
  }, [timeRange, name, queryValues, streams.streamsRepositoryClient]);
  return previewFetch;
}