"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.SignificantEventsViewEmptyState = SignificantEventsViewEmptyState;
var _eui = require("@elastic/eui");
var _react = _interopRequireDefault(require("react"));
var _i18n = require("@kbn/i18n");
var _asset_image = require("../asset_image");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

function SignificantEventsViewEmptyState({
  onAddClick
}) {
  return /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
    direction: "column",
    alignItems: "center",
    justifyContent: "center"
  }, /*#__PURE__*/_react.default.createElement(_asset_image.AssetImage, {
    type: "significantEventsEmptyState",
    size: "s"
  }), /*#__PURE__*/_react.default.createElement(_eui.EuiTitle, {
    size: "s"
  }, /*#__PURE__*/_react.default.createElement("h2", null, _i18n.i18n.translate('xpack.streams.significantEvents.emptyState.title', {
    defaultMessage: 'No significant event definitions'
  }))), /*#__PURE__*/_react.default.createElement(_eui.EuiText, {
    size: "s",
    textAlign: "center"
  }, _i18n.i18n.translate('xpack.streams.significantEvents.emptyState.description', {
    defaultMessage: 'There are no significant events defined for this stream yet.'
  })), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
    direction: "row",
    gutterSize: "s"
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiButton, {
    iconType: "plusInCircle",
    fill: true,
    onClick: () => {
      onAddClick === null || onAddClick === void 0 ? void 0 : onAddClick();
    }
  }, _i18n.i18n.translate('xpack.streams.significantEvents.emptyState.addEvent', {
    defaultMessage: 'Add new event'
  }))));
}