"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.QuickLinks = QuickLinks;
var _eui = require("@elastic/eui");
var _i18n = require("@kbn/i18n");
var _react = _interopRequireDefault(require("react"));
var _css = require("@emotion/css");
var _use_dashboards_fetch = require("../../hooks/use_dashboards_fetch");
var _asset_image = require("../asset_image");
var _use_streams_app_router = require("../../hooks/use_streams_app_router");
var _dashboard_table = require("../stream_detail_dashboards_view/dashboard_table");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const EMPTY_DASHBOARD_LIST = [];
function QuickLinks({
  definition
}) {
  var _dashboardsFetch$valu, _dashboardsFetch$valu2, _dashboardsFetch$valu3;
  const router = (0, _use_streams_app_router.useStreamsAppRouter)();
  const dashboardsFetch = (0, _use_dashboards_fetch.useDashboardsFetch)(definition.stream.name);
  if (definition && !dashboardsFetch.loading && ((_dashboardsFetch$valu = dashboardsFetch.value) === null || _dashboardsFetch$valu === void 0 ? void 0 : _dashboardsFetch$valu.dashboards.length) === 0) {
    return /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
      grow: true
    }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
      alignItems: "center",
      justifyContent: "center"
    }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
      grow: false,
      className: (0, _css.css)`
              max-width: 200px;
            `
    }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
      direction: "column",
      gutterSize: "s"
    }, /*#__PURE__*/_react.default.createElement(_asset_image.AssetImage, {
      type: "quickLinksEmpty"
    }), /*#__PURE__*/_react.default.createElement(_eui.EuiText, {
      size: "xs",
      textAlign: "center",
      color: "subdued"
    }, _i18n.i18n.translate('xpack.streams.entityDetailOverview.linkDashboardsText', {
      defaultMessage: 'Link dashboards to this stream for quick access'
    })), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
      justifyContent: "center"
    }, /*#__PURE__*/_react.default.createElement(_eui.EuiLink, {
      href: router.link('/{key}/{tab}', {
        path: {
          key: definition.stream.name,
          tab: 'dashboards'
        }
      })
    }, _i18n.i18n.translate('xpack.streams.entityDetailOverview.addDashboardButton', {
      defaultMessage: 'Add dashboards'
    })))))));
  }
  return /*#__PURE__*/_react.default.createElement(_dashboard_table.DashboardsTable, {
    dashboards: (_dashboardsFetch$valu2 = (_dashboardsFetch$valu3 = dashboardsFetch.value) === null || _dashboardsFetch$valu3 === void 0 ? void 0 : _dashboardsFetch$valu3.dashboards) !== null && _dashboardsFetch$valu2 !== void 0 ? _dashboardsFetch$valu2 : EMPTY_DASHBOARD_LIST,
    loading: dashboardsFetch.loading
  });
}