"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.StreamDetailDashboardsView = StreamDetailDashboardsView;
var _eui = require("@elastic/eui");
var _i18n = require("@kbn/i18n");
var _public = require("@kbn/streams-plugin/public");
var _react = _interopRequireWildcard(require("react"));
var _feature_flags = require("../../../common/feature_flags");
var _use_dashboards_api = require("../../hooks/use_dashboards_api");
var _use_dashboards_fetch = require("../../hooks/use_dashboards_fetch");
var _use_kibana = require("../../hooks/use_kibana");
var _add_dashboard_flyout = require("./add_dashboard_flyout");
var _dashboard_table = require("./dashboard_table");
var _export_content_pack_flyout = require("./export_content_pack_flyout");
var _import_content_pack_flyout = require("./import_content_pack_flyout");
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

function StreamDetailDashboardsView({
  definition
}) {
  var _dashboardsFetch$valu3;
  const [query, setQuery] = (0, _react.useState)('');
  const [isAddDashboardFlyoutOpen, setIsAddDashboardFlyoutOpen] = (0, _react.useState)(false);
  const [isImportFlyoutOpen, setIsImportFlyoutOpen] = (0, _react.useState)(false);
  const [isExportFlyoutOpen, setIsExportFlyoutOpen] = (0, _react.useState)(false);
  const dashboardsFetch = (0, _use_dashboards_fetch.useDashboardsFetch)(definition.stream.name);
  const {
    addDashboards,
    removeDashboards
  } = (0, _use_dashboards_api.useDashboardsApi)(definition.stream.name);
  const [isUnlinkLoading, setIsUnlinkLoading] = (0, _react.useState)(false);
  const linkedDashboards = (0, _react.useMemo)(() => {
    var _dashboardsFetch$valu, _dashboardsFetch$valu2;
    return (_dashboardsFetch$valu = (_dashboardsFetch$valu2 = dashboardsFetch.value) === null || _dashboardsFetch$valu2 === void 0 ? void 0 : _dashboardsFetch$valu2.dashboards) !== null && _dashboardsFetch$valu !== void 0 ? _dashboardsFetch$valu : [];
  }, [(_dashboardsFetch$valu3 = dashboardsFetch.value) === null || _dashboardsFetch$valu3 === void 0 ? void 0 : _dashboardsFetch$valu3.dashboards]);
  const filteredDashboards = (0, _react.useMemo)(() => {
    return linkedDashboards.filter(dashboard => {
      return dashboard.title.toLowerCase().includes(query.toLowerCase());
    });
  }, [linkedDashboards, query]);
  const [selectedDashboards, setSelectedDashboards] = (0, _react.useState)([]);
  const [isPopoverOpen, setIsPopoverOpen] = (0, _react.useState)(false);
  const {
    core: {
      featureFlags,
      application: {
        capabilities: {
          streams: {
            [_public.STREAMS_UI_PRIVILEGES.manage]: canLinkAssets
          }
        }
      }
    }
  } = (0, _use_kibana.useKibana)();
  const renderContentPackItems = featureFlags.getBooleanValue(_feature_flags.FeatureFlagStreamsContentPackUIEnabled, false);
  return /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
    direction: "column"
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    grow: false
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
    direction: "row",
    gutterSize: "s"
  }, selectedDashboards.length > 0 && /*#__PURE__*/_react.default.createElement(_eui.EuiButton, {
    "data-test-subj": "streamsAppStreamDetailRemoveDashboardButton",
    iconType: "trash",
    isLoading: isUnlinkLoading,
    onClick: async () => {
      try {
        setIsUnlinkLoading(true);
        await removeDashboards(selectedDashboards);
        dashboardsFetch.refresh();
        setSelectedDashboards([]);
      } finally {
        setIsUnlinkLoading(false);
      }
    },
    color: "danger"
  }, _i18n.i18n.translate('xpack.streams.streamDetailDashboardView.removeSelectedButtonLabel', {
    defaultMessage: 'Unlink selected'
  })), /*#__PURE__*/_react.default.createElement(_eui.EuiSearchBar, {
    query: query,
    box: {
      incremental: true
    },
    onChange: nextQuery => {
      setQuery(nextQuery.queryText);
    }
  }), renderContentPackItems && /*#__PURE__*/_react.default.createElement(_eui.EuiButton, {
    "data-test-subj": "streamsAppStreamDetailExportContentPackButton",
    iconType: "exportAction",
    isDisabled: linkedDashboards.length === 0,
    onClick: () => {
      setIsExportFlyoutOpen(true);
    }
  }, _i18n.i18n.translate('xpack.streams.streamDetailDashboardView.exportContentPackButton', {
    defaultMessage: 'Export content pack'
  })), renderContentPackItems ? /*#__PURE__*/_react.default.createElement(_eui.EuiPopover, {
    button: /*#__PURE__*/_react.default.createElement(_eui.EuiButton, {
      iconType: "importAction",
      iconSide: "left",
      color: "primary",
      disabled: !canLinkAssets,
      onClick: () => setIsPopoverOpen(true)
    }, _i18n.i18n.translate('xpack.streams.streamDetailDashboardView.addDashboardsButtonLabel', {
      defaultMessage: 'Add dashboards'
    })),
    isOpen: isPopoverOpen,
    closePopover: () => setIsPopoverOpen(false),
    panelPaddingSize: "none",
    anchorPosition: "downLeft"
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiContextMenuPanel, {
    size: "s",
    items: [/*#__PURE__*/_react.default.createElement(_eui.EuiContextMenuItem, {
      "data-test-subj": "streamsAppStreamDetailAddDashboardButton",
      key: "addDashboard",
      icon: "plusInCircle",
      onClick: () => {
        setIsPopoverOpen(false);
        setIsAddDashboardFlyoutOpen(true);
      }
    }, _i18n.i18n.translate('xpack.streams.streamDetailDashboardView.addADashboardButtonLabel', {
      defaultMessage: 'Add a dashboard'
    })), /*#__PURE__*/_react.default.createElement(_eui.EuiContextMenuItem, {
      "data-test-subj": "streamsAppStreamDetailImportContentPackButton",
      key: "importContentPack",
      icon: "importAction",
      onClick: () => {
        setIsPopoverOpen(false);
        setIsImportFlyoutOpen(true);
      }
    }, _i18n.i18n.translate('xpack.streams.streamDetailDashboardView.importContentPackButtonLabel', {
      defaultMessage: 'Import from content pack'
    }))]
  })) : /*#__PURE__*/_react.default.createElement(_eui.EuiButton, {
    "data-test-subj": "streamsAppStreamDetailAddDashboardButton",
    iconType: "plusInCircle",
    disabled: !canLinkAssets,
    onClick: () => {
      setIsAddDashboardFlyoutOpen(true);
    }
  }, _i18n.i18n.translate('xpack.streams.streamDetailDashboardView.addADashboardButtonLabel', {
    defaultMessage: 'Add a dashboard'
  })))), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, null, /*#__PURE__*/_react.default.createElement(_dashboard_table.DashboardsTable, {
    entityId: definition === null || definition === void 0 ? void 0 : definition.stream.name,
    dashboards: filteredDashboards,
    loading: dashboardsFetch.loading,
    selectedDashboards: selectedDashboards,
    setSelectedDashboards: canLinkAssets ? setSelectedDashboards : undefined,
    dataTestSubj: "streamsAppStreamDetailDashboardsTable"
  }), definition && isAddDashboardFlyoutOpen ? /*#__PURE__*/_react.default.createElement(_add_dashboard_flyout.AddDashboardFlyout, {
    linkedDashboards: linkedDashboards,
    entityId: definition.stream.name,
    onAddDashboards: async dashboards => {
      await addDashboards(dashboards);
      dashboardsFetch.refresh();
      setIsAddDashboardFlyoutOpen(false);
    },
    onClose: () => {
      setIsAddDashboardFlyoutOpen(false);
    }
  }) : null, definition && isImportFlyoutOpen ? /*#__PURE__*/_react.default.createElement(_import_content_pack_flyout.ImportContentPackFlyout, {
    definition: definition,
    onImport: () => {
      dashboardsFetch.refresh();
      setIsImportFlyoutOpen(false);
    },
    onClose: () => {
      setIsImportFlyoutOpen(false);
    }
  }) : null, definition && isExportFlyoutOpen ? /*#__PURE__*/_react.default.createElement(_export_content_pack_flyout.ExportContentPackFlyout, {
    definition: definition,
    onExport: () => {
      setIsExportFlyoutOpen(false);
    },
    onClose: () => {
      setIsExportFlyoutOpen(false);
    }
  }) : null));
}