"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.importContent = importContent;
exports.previewContent = previewContent;
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

async function importContent({
  file,
  http,
  definition,
  include
}) {
  const body = new FormData();
  body.append('content', file);
  body.append('include', JSON.stringify(include));
  const response = await http.post(`/api/streams/${definition.stream.name}/content/import`, {
    body,
    headers: {
      // Important to be undefined, it forces proper headers to be set for FormData
      'Content-Type': undefined
    }
  });
  return response;
}
async function previewContent({
  http,
  file,
  definition
}) {
  const body = new FormData();
  body.append('content', file);
  const contentPack = await http.post(`/internal/streams/${definition.stream.name}/content/preview`, {
    body,
    headers: {
      // Important to be undefined, it forces proper headers to be set for FormData
      'Content-Type': undefined
    }
  });
  return contentPack;
}