"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.IngestPipelineDetails = IngestPipelineDetails;
var _react = _interopRequireDefault(require("react"));
var _i18n = require("@kbn/i18n");
var _eui = require("@elastic/eui");
var _css = require("@emotion/css");
var _managed_badge = require("./managed_badge");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

function IngestPipelineDetails({
  ingestPipeline,
  onFlyoutOpen
}) {
  return /*#__PURE__*/_react.default.createElement(_eui.EuiPanel, {
    hasShadow: false,
    hasBorder: true,
    className: (0, _css.css)`
        min-width: 300px;
        max-height: 100px;
      `
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
    direction: "column",
    gutterSize: "s"
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiTitle, {
    size: "xs"
  }, /*#__PURE__*/_react.default.createElement("p", null, _i18n.i18n.translate('xpack.streams.streamDetailView.ingestPipeline', {
    defaultMessage: 'Ingest pipeline'
  }))), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
    direction: "row",
    gutterSize: "xs"
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
    direction: "column",
    gutterSize: "xs"
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiTitle, {
    size: "xxxs"
  }, /*#__PURE__*/_react.default.createElement("p", null, _i18n.i18n.translate('xpack.streams.streamDetailView.ingestPipelineName', {
    defaultMessage: 'Name'
  }))), ingestPipeline ? /*#__PURE__*/_react.default.createElement(_eui.EuiLink, {
    onClick: () => onFlyoutOpen(ingestPipeline.name)
  }, ingestPipeline.name, /*#__PURE__*/_react.default.createElement(_managed_badge.ManagedBadge, {
    meta: ingestPipeline === null || ingestPipeline === void 0 ? void 0 : ingestPipeline._meta
  })) : /*#__PURE__*/_react.default.createElement(_eui.EuiText, {
    size: "s"
  }, "-")))));
}