"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.StreamDetailLifecycle = StreamDetailLifecycle;
var _eui = require("@elastic/eui");
var _react = _interopRequireWildcard(require("react"));
var _streamsSchema = require("@kbn/streams-schema");
var _i18n = require("@kbn/i18n");
var _reactHooks = require("@kbn/react-hooks");
var _react2 = require("@emotion/react");
var _use_kibana = require("../../../hooks/use_kibana");
var _modal = require("./modal");
var _summary = require("./summary");
var _metadata = require("./metadata");
var _ilm_summary = require("./ilm_summary");
var _ingestion_rate = require("./ingestion_rate");
var _use_data_stream_stats = require("./hooks/use_data_stream_stats");
var _errors = require("../../../util/errors");
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

function useLifecycleState({
  definition,
  isServerless
}) {
  const [updateInProgress, setUpdateInProgress] = (0, _react.useState)(false);
  const [openEditModal, setOpenEditModal] = (0, _react.useState)('none');
  const lifecycleActions = (0, _react.useMemo)(() => {
    const actions = [];
    const isUnwired = _streamsSchema.Streams.UnwiredStream.GetResponse.is(definition);
    actions.push({
      name: _i18n.i18n.translate('xpack.streams.streamDetailLifecycle.setRetentionDays', {
        defaultMessage: 'Set specific retention days'
      }),
      action: 'dsl'
    });
    if (!isServerless) {
      actions.push({
        name: _i18n.i18n.translate('xpack.streams.streamDetailLifecycle.setLifecyclePolicy', {
          defaultMessage: 'Use a lifecycle policy'
        }),
        action: 'ilm'
      });
    }
    if (isUnwired || !(0, _streamsSchema.isRoot)(definition.stream.name)) {
      actions.push({
        name: _i18n.i18n.translate('xpack.streams.streamDetailLifecycle.resetToDefault', {
          defaultMessage: 'Reset to default'
        }),
        action: 'inherit'
      });
    }
    return actions;
  }, [definition, isServerless]);
  return {
    lifecycleActions,
    openEditModal,
    setOpenEditModal,
    updateInProgress,
    setUpdateInProgress
  };
}
function StreamDetailLifecycle({
  definition,
  refreshDefinition
}) {
  const {
    core: {
      http,
      notifications
    },
    dependencies: {
      start: {
        streams: {
          streamsRepositoryClient
        }
      }
    },
    isServerless
  } = (0, _use_kibana.useKibana)();
  const {
    lifecycleActions,
    openEditModal,
    setOpenEditModal,
    updateInProgress,
    setUpdateInProgress
  } = useLifecycleState({
    definition,
    isServerless
  });
  const {
    stats,
    isLoading: isLoadingStats,
    error: statsError
  } = (0, _use_data_stream_stats.useDataStreamStats)({
    definition
  });
  const {
    signal
  } = (0, _reactHooks.useAbortController)();
  const getIlmPolicies = () => http.get('/api/index_lifecycle_management/policies', {
    signal
  });
  const updateLifecycle = async lifecycle => {
    try {
      setUpdateInProgress(true);
      const request = {
        ingest: {
          ...definition.stream.ingest,
          lifecycle
        }
      };
      await streamsRepositoryClient.fetch('PUT /api/streams/{name}/_ingest 2023-10-31', {
        params: {
          path: {
            name: definition.stream.name
          },
          body: request
        },
        signal
      });
      refreshDefinition();
      setOpenEditModal('none');
      notifications.toasts.addSuccess({
        title: _i18n.i18n.translate('xpack.streams.streamDetailLifecycle.updated', {
          defaultMessage: 'Stream lifecycle updated'
        })
      });
    } catch (error) {
      notifications.toasts.addError(error, {
        title: _i18n.i18n.translate('xpack.streams.streamDetailLifecycle.failed', {
          defaultMessage: 'Failed to update lifecycle'
        }),
        toastMessage: (0, _errors.getFormattedError)(error).message
      });
    } finally {
      setUpdateInProgress(false);
    }
  };
  return /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
    gutterSize: "m",
    direction: "column"
  }, /*#__PURE__*/_react.default.createElement(_modal.EditLifecycleModal, {
    action: openEditModal,
    definition: definition,
    closeModal: () => setOpenEditModal('none'),
    updateLifecycle: updateLifecycle,
    getIlmPolicies: getIlmPolicies,
    updateInProgress: updateInProgress
  }), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
    gutterSize: "m",
    css: flexRowCss
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiPanel, {
    grow: false,
    hasShadow: false,
    hasBorder: true,
    paddingSize: "m"
  }, /*#__PURE__*/_react.default.createElement(_summary.RetentionSummary, {
    definition: definition,
    stats: stats,
    statsError: statsError
  })), /*#__PURE__*/_react.default.createElement(_eui.EuiPanel, {
    grow: true,
    hasShadow: false,
    hasBorder: true,
    paddingSize: "m"
  }, /*#__PURE__*/_react.default.createElement(_metadata.RetentionMetadata, {
    definition: definition,
    lifecycleActions: lifecycleActions,
    openEditModal: action => setOpenEditModal(action),
    stats: stats,
    statsError: statsError
  }))), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
    gutterSize: "m",
    css: flexRowCss
  }, definition.privileges.monitor && /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    grow: 2
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiPanel, {
    hasShadow: false,
    hasBorder: true,
    paddingSize: "m"
  }, /*#__PURE__*/_react.default.createElement(_ingestion_rate.IngestionRate, {
    definition: definition,
    isLoadingStats: isLoadingStats,
    stats: stats
  }))), definition.privileges.lifecycle && (0, _streamsSchema.isIlmLifecycle)(definition.effective_lifecycle) ? /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    grow: 3
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiPanel, {
    hasShadow: false,
    hasBorder: true,
    paddingSize: "m"
  }, /*#__PURE__*/_react.default.createElement(_ilm_summary.IlmSummary, {
    definition: definition,
    stats: stats,
    lifecycle: definition.effective_lifecycle
  }))) : null));
}
const flexRowCss = (0, _react2.css)`
  flex-grow: 0;
`;