"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.IlmSummary = IlmSummary;
var _lodash = require("lodash");
var _react = _interopRequireWildcard(require("react"));
var _i18n = require("@kbn/i18n");
var _eui = require("@elastic/eui");
var _use_streams_app_fetch = require("../../../hooks/use_streams_app_fetch");
var _use_kibana = require("../../../hooks/use_kibana");
var _helpers = require("./helpers");
var _ilm_link = require("./ilm_link");
var _use_ilm_phases_color_and_description = require("./hooks/use_ilm_phases_color_and_description");
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

function IlmSummary({
  definition,
  lifecycle,
  stats
}) {
  const {
    dependencies: {
      start: {
        streams: {
          streamsRepositoryClient
        }
      }
    }
  } = (0, _use_kibana.useKibana)();
  const {
    value,
    loading,
    error
  } = (0, _use_streams_app_fetch.useStreamsAppFetch)(({
    signal
  }) => {
    return streamsRepositoryClient.fetch('GET /internal/streams/{name}/lifecycle/_stats', {
      params: {
        path: {
          name: definition.stream.name
        }
      },
      signal
    });
  },
  // we pass the stats as a hack to refresh the ilm summary
  // when the ingestion rate graph is refreshed
  // eslint-disable-next-line react-hooks/exhaustive-deps
  [streamsRepositoryClient, definition, stats]);
  const phasesWithGrow = (0, _react.useMemo)(() => {
    if (!value) return undefined;
    const orderedPhases = (0, _helpers.orderIlmPhases)(value.phases);
    const totalDuration = (0, _helpers.parseDurationInSeconds)((0, _lodash.last)(orderedPhases).min_age);
    return orderedPhases.map((phase, index, phases) => {
      const nextPhase = phases[index + 1];
      if (!nextPhase) {
        return {
          ...phase,
          grow: phase.name === 'delete' ? false : 2
        };
      }
      const phaseDuration = (0, _helpers.parseDurationInSeconds)(nextPhase.min_age) - (0, _helpers.parseDurationInSeconds)(phase.min_age);
      return {
        ...phase,
        grow: Math.max(2, Math.round(phaseDuration / totalDuration * 10))
      };
    });
  }, [value]);
  return /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
    direction: "column",
    gutterSize: "none"
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiPanel, {
    hasShadow: false,
    hasBorder: false,
    paddingSize: "s"
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
    alignItems: "center"
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, null, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
    alignItems: "center",
    gutterSize: "s"
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiText, null, /*#__PURE__*/_react.default.createElement("h5", null, _i18n.i18n.translate('xpack.streams.streamDetailLifecycle.policySummary', {
    defaultMessage: 'Policy summary'
  }))), loading ? /*#__PURE__*/_react.default.createElement(_eui.EuiLoadingSpinner, {
    size: "s"
  }) : null), /*#__PURE__*/_react.default.createElement(_eui.EuiTextColor, {
    color: "subdued"
  }, _i18n.i18n.translate('xpack.streams.streamDetailLifecycle.policySummaryInfo', {
    defaultMessage: 'Phases and details of the lifecycle applied to this stream'
  }))), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    grow: false
  }, /*#__PURE__*/_react.default.createElement(_ilm_link.IlmLink, {
    lifecycle: lifecycle
  })))), /*#__PURE__*/_react.default.createElement(_eui.EuiPanel, {
    grow: true,
    hasShadow: false,
    hasBorder: false,
    paddingSize: "s"
  }, error || !phasesWithGrow ? null : /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
    direction: "row",
    gutterSize: "none",
    responsive: false
  }, phasesWithGrow.map((phase, index) => {
    var _phasesWithGrow;
    return /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
      key: `${phase.name}-timeline`,
      grow: phase.grow
    }, /*#__PURE__*/_react.default.createElement(IlmPhase, {
      phase: phase,
      minAge: (_phasesWithGrow = phasesWithGrow[index + 1]) === null || _phasesWithGrow === void 0 ? void 0 : _phasesWithGrow.min_age
    }));
  }))), /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, {
    size: "m"
  }), /*#__PURE__*/_react.default.createElement(PhasesLegend, {
    phases: value === null || value === void 0 ? void 0 : value.phases
  }));
}
function IlmPhase({
  phase,
  minAge
}) {
  const borderRadius = phase.name === 'delete' ? undefined : phase.name === 'hot' ? minAge ? '0px 16px 16px 0px' : '0px' : minAge ? '16px' : '16px 0px 0px 16px';
  const {
    ilmPhases
  } = (0, _use_ilm_phases_color_and_description.useIlmPhasesColorAndDescription)();
  const {
    euiTheme
  } = (0, _eui.useEuiTheme)();
  return /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
    direction: "column",
    gutterSize: "xs",
    css: phase.name !== 'delete' ? {
      borderRight: '1px dashed black'
    } : undefined
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiPanel, {
    paddingSize: "s",
    hasBorder: false,
    hasShadow: false,
    css: {
      backgroundColor: ilmPhases[phase.name].color,
      margin: '0 2px',
      borderRadius
    },
    grow: false
  }, phase.name === 'delete' ? /*#__PURE__*/_react.default.createElement(_eui.EuiText, {
    size: "xs",
    css: {
      margin: '0 2px'
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiIcon, {
    size: "s",
    type: "trash"
  })) : /*#__PURE__*/_react.default.createElement(_eui.EuiText, {
    size: "xs",
    color: euiTheme.colors.plainDark
  }, /*#__PURE__*/_react.default.createElement("b", null, (0, _lodash.capitalize)(phase.name)))), 'size_in_bytes' in phase ? /*#__PURE__*/_react.default.createElement(_eui.EuiPanel, {
    paddingSize: "s",
    borderRadius: "none",
    hasBorder: false,
    hasShadow: false,
    grow: false,
    css: {
      marginBottom: '40px'
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiText, {
    size: "xs"
  }, /*#__PURE__*/_react.default.createElement("p", null, /*#__PURE__*/_react.default.createElement("b", null, "Size"), " ", (0, _eui.formatNumber)(phase.size_in_bytes, '0.0 ib')))) : null), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
    justifyContent: "flexEnd"
  }, phase.name !== 'delete' ? /*#__PURE__*/_react.default.createElement(_eui.EuiPanel, {
    paddingSize: "xs",
    css: {
      marginRight: minAge ? '-20px' : '-5px',
      width: '50px',
      backgroundColor: ilmPhases.delete.color
    },
    grow: false,
    hasBorder: false,
    hasShadow: false
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiText, {
    textAlign: "center",
    size: "xs"
  }, minAge ? minAge + (phase.name === 'hot' ? '*' : '') : '∞')) : undefined));
}
function PhasesLegend({
  phases
}) {
  const {
    ilmPhases
  } = (0, _use_ilm_phases_color_and_description.useIlmPhasesColorAndDescription)();
  const descriptions = (0, _react.useMemo)(() => {
    if (!phases) return [];
    const desc = (0, _helpers.orderIlmPhases)(phases).filter(({
      name
    }) => name !== 'delete').map(phase => ({
      name: phase.name,
      description: ilmPhases[phase.name].description(phase, phases),
      color: ilmPhases[phase.name].color
    }));
    if (phases.delete) {
      desc.push({
        name: 'delete',
        description: ilmPhases.delete.description(phases.delete),
        icon: 'trash'
      });
    } else {
      desc.push({
        name: 'indefinite',
        description: [_i18n.i18n.translate('xpack.streams.streamDetailLifecycle.noRetentionDescription', {
          defaultMessage: 'Data is stored indefinitely.'
        })],
        icon: 'infinity'
      });
    }
    return desc;
  }, [phases, ilmPhases]);
  if (!phases) return null;
  return /*#__PURE__*/_react.default.createElement(_eui.EuiPanel, {
    hasBorder: false,
    hasShadow: false,
    paddingSize: "s"
  }, descriptions.map((phase, index) => /*#__PURE__*/_react.default.createElement(_react.default.Fragment, {
    key: phase.name
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
    alignItems: "center"
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    grow: false,
    css: {
      width: '20px',
      alignItems: 'center'
    }
  }, 'color' in phase ? /*#__PURE__*/_react.default.createElement("span", {
    style: {
      height: '12px',
      width: '12px',
      borderRadius: '50%',
      backgroundColor: phase.color,
      display: 'inline-block'
    }
  }) : /*#__PURE__*/_react.default.createElement(_eui.EuiIcon, {
    type: phase.icon
  })), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    grow: 2
  }, /*#__PURE__*/_react.default.createElement("b", null, (0, _lodash.capitalize)(phase.name))), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    grow: 10
  }, phase.description.map((desc, idx) => /*#__PURE__*/_react.default.createElement(_eui.EuiTextColor, {
    key: `${phase.name}-desc-${idx}`,
    color: "subdued"
  }, desc)))), index === descriptions.length - 1 ? null : /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, {
    size: "s"
  }))));
}