"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.SimulationPlayground = void 0;
var _react = _interopRequireDefault(require("react"));
var _i18n = require("@kbn/i18n");
var _eui = require("@elastic/eui");
var _processor_outcome_preview = require("./processor_outcome_preview");
var _stream_enrichment_state_machine = require("./state_management/stream_enrichment_state_machine");
var _detected_fields_editor = require("./detected_fields_editor");
var _data_sources_list = require("./data_sources_list");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const SimulationPlayground = () => {
  const {
    refreshSimulation,
    viewSimulationPreviewData,
    viewSimulationDetectedFields
  } = (0, _stream_enrichment_state_machine.useStreamEnrichmentEvents)();
  const isViewingDataPreview = (0, _stream_enrichment_state_machine.useStreamEnrichmentSelector)(state => state.matches({
    ready: {
      enrichment: {
        displayingSimulation: 'viewDataPreview'
      }
    }
  }));
  const isViewingDetectedFields = (0, _stream_enrichment_state_machine.useStreamEnrichmentSelector)(state => state.matches({
    ready: {
      enrichment: {
        displayingSimulation: 'viewDetectedFields'
      }
    }
  }));
  const detectedFields = (0, _stream_enrichment_state_machine.useSimulatorSelector)(state => state.context.detectedSchemaFields);
  const isLoading = (0, _stream_enrichment_state_machine.useSimulatorSelector)(state => state.matches('debouncingChanges') || state.matches('runningSimulation'));
  return /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    grow: false
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
    justifyContent: "spaceBetween",
    alignItems: "center"
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, null, /*#__PURE__*/_react.default.createElement(_eui.EuiTabs, {
    bottomBorder: false
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiTab, {
    isSelected: isViewingDataPreview,
    onClick: viewSimulationPreviewData,
    append: /*#__PURE__*/_react.default.createElement(_eui.EuiButtonIcon, {
      iconType: "refresh",
      onClick: refreshSimulation,
      isLoading: isLoading,
      "aria-label": _i18n.i18n.translate('xpack.streams.streamDetailView.managementTab.enrichment.simulationPlayground.refreshPreviewAriaLabel', {
        defaultMessage: 'Refresh data preview'
      })
    })
  }, _i18n.i18n.translate('xpack.streams.streamDetailView.managementTab.enrichment.simulationPlayground.dataPreview', {
    defaultMessage: 'Data preview'
  })), /*#__PURE__*/_react.default.createElement(_eui.EuiTab, {
    isSelected: isViewingDetectedFields,
    onClick: viewSimulationDetectedFields,
    append: detectedFields.length > 0 ? /*#__PURE__*/_react.default.createElement(_eui.EuiNotificationBadge, {
      size: "m"
    }, detectedFields.length) : undefined
  }, _i18n.i18n.translate('xpack.streams.streamDetailView.managementTab.enrichment.simulationPlayground.detectedFields', {
    defaultMessage: 'Detected fields'
  })))), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    grow: false
  }, /*#__PURE__*/_react.default.createElement(_data_sources_list.DataSourcesList, null)), isLoading && /*#__PURE__*/_react.default.createElement(_eui.EuiProgress, {
    size: "xs",
    color: "accent",
    position: "absolute"
  }))), /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, {
    size: "m"
  }), isViewingDataPreview && /*#__PURE__*/_react.default.createElement(_processor_outcome_preview.ProcessorOutcomePreview, null), isViewingDetectedFields && /*#__PURE__*/_react.default.createElement(_detected_fields_editor.DetectedFieldsEditor, {
    detectedFields: detectedFields
  }));
};
exports.SimulationPlayground = SimulationPlayground;