"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.ProcessorFieldSelector = void 0;
var _extends2 = _interopRequireDefault(require("@babel/runtime/helpers/extends"));
var _eui = require("@elastic/eui");
var _i18n = require("@kbn/i18n");
var _react = _interopRequireDefault(require("react"));
var _reactHookForm = require("react-hook-form");
var _react2 = require("@emotion/react");
var _stream_enrichment_state_machine = require("../state_management/stream_enrichment_state_machine");
var _selectors = require("../state_management/simulation_state_machine/selectors");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const ProcessorFieldSelector = ({
  helpText,
  onChange
}) => {
  const {
    euiTheme
  } = (0, _eui.useEuiTheme)();
  const unsupportedFields = (0, _stream_enrichment_state_machine.useSimulatorSelector)(state => (0, _selectors.selectUnsupportedDottedFields)(state.context));
  const {
    field,
    fieldState
  } = (0, _reactHookForm.useController)({
    name: 'field',
    rules: {
      required: _i18n.i18n.translate('xpack.streams.streamDetailView.managementTab.enrichment.processor.fieldSelectorRequiredError', {
        defaultMessage: 'A field value is required.'
      })
    }
  });
  const {
    ref,
    value,
    ...inputProps
  } = field;
  const {
    invalid,
    error
  } = fieldState;
  const handleChange = event => {
    field.onChange(event);
    if (onChange) {
      onChange(event);
    }
  };
  const isUnsupported = unsupportedFields.some(unsupportedField => value.startsWith(unsupportedField));
  return /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, /*#__PURE__*/_react.default.createElement(_eui.EuiFormRow, {
    label: _i18n.i18n.translate('xpack.streams.streamDetailView.managementTab.enrichment.processor.fieldSelectorLabel', {
      defaultMessage: 'Field'
    }),
    helpText: helpText !== null && helpText !== void 0 ? helpText : _i18n.i18n.translate('xpack.streams.streamDetailView.managementTab.enrichment.processor.fieldSelectorHelpText', {
      defaultMessage: 'Field to search for matches.'
    }),
    isInvalid: invalid,
    error: error === null || error === void 0 ? void 0 : error.message
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFieldText, (0, _extends2.default)({
    "data-test-subj": "streamsAppProcessorFieldSelectorFieldText"
  }, inputProps, {
    onChange: handleChange,
    value: value,
    inputRef: ref,
    isInvalid: invalid
  }))), isUnsupported && /*#__PURE__*/_react.default.createElement(_eui.EuiCallOut, {
    color: "warning",
    iconType: "alert",
    title: _i18n.i18n.translate('xpack.streams.streamDetailView.managementTab.enrichment.processor.fieldSelectorUnsupportedDottedFieldsWarning.title', {
      defaultMessage: 'Dot-separated field names are not supported.'
    }),
    css: (0, _react2.css)`
            margin-top: ${euiTheme.size.s};
            margin-bottom: ${euiTheme.size.m};
          `
  }, /*#__PURE__*/_react.default.createElement("p", null, _i18n.i18n.translate('xpack.streams.streamDetailView.managementTab.enrichment.processor.fieldSelectorUnsupportedDottedFieldsWarning.p1', {
    defaultMessage: 'Dot-separated field names in processors can produce misleading simulation results.'
  })), /*#__PURE__*/_react.default.createElement("p", null, _i18n.i18n.translate('xpack.streams.streamDetailView.managementTab.enrichment.processor.fieldSelectorUnsupportedDottedFieldsWarning.p2', {
    defaultMessage: 'For accurate results, avoid dot-separated field names or expand them into nested objects.'
  }))));
};
exports.ProcessorFieldSelector = ProcessorFieldSelector;