"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.DateProcessorForm = void 0;
var _react = _interopRequireDefault(require("react"));
var _eui = require("@elastic/eui");
var _lodash = require("lodash");
var _reactHookForm = require("react-hook-form");
var _i18n = require("@kbn/i18n");
var _useMount = _interopRequireDefault(require("react-use/lib/useMount"));
var _common = require("@kbn/streams-plugin/common");
var _errors = require("../../../../../util/errors");
var _use_kibana = require("../../../../../hooks/use_kibana");
var _processor_field_selector = require("../processor_field_selector");
var _optional_fields_accordion = require("../optional_fields_accordion");
var _processor_condition_editor = require("../processor_condition_editor");
var _ignore_toggles = require("../ignore_toggles");
var _date_optional_fields = require("./date_optional_fields");
var _date_formats_field = require("./date_formats_field");
var _selectors = require("../../state_management/simulation_state_machine/selectors");
var _stream_enrichment_state_machine = require("../../state_management/stream_enrichment_state_machine");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const DateProcessorForm = () => {
  const {
    core,
    dependencies
  } = (0, _use_kibana.useKibana)();
  const {
    toasts
  } = core.notifications;
  const {
    streamsRepositoryClient
  } = dependencies.start.streams;
  const form = (0, _reactHookForm.useFormContext)();
  const definition = (0, _stream_enrichment_state_machine.useStreamEnrichmentSelector)(snapshot => snapshot.context.definition);
  const previewDocuments = (0, _stream_enrichment_state_machine.useSimulatorSelector)(snapshot => (0, _selectors.selectPreviewDocuments)(snapshot.context));
  const applySuggestions = async ({
    field
  }) => {
    // Collect sample dates from the preview documents for the selected field
    const dates = previewDocuments.map(doc => doc[field]).filter(Boolean);

    // Short-circuit if the formats is touched by the user, formats are already set, or no date samples are available
    if ((0, _lodash.isEmpty)(dates)) return;
    try {
      const suggestions = await streamsRepositoryClient.fetch('POST /internal/streams/{name}/processing/_suggestions/date', {
        signal: null,
        params: {
          path: {
            name: definition.stream.name
          },
          body: {
            dates: dates // At least one sample is required by the API
          }
        }
      });
      if (!(0, _lodash.isEmpty)(suggestions.formats)) {
        // Merge the suggested formats with the existing ones
        const prevFormats = form.getValues('formats');
        form.setValue('formats', (0, _lodash.uniq)([...prevFormats, ...suggestions.formats]));
        form.clearErrors();
      }
    } catch (error) {
      const formattedError = (0, _errors.getFormattedError)(error);
      toasts.addError(formattedError, {
        title: _i18n.i18n.translate('xpack.streams.enrichment.simulation.dateSuggestionsError', {
          defaultMessage: 'An error occurred while fetching date formats suggestions.'
        }),
        toastMessage: formattedError.message,
        toastLifeTimeMs: 5000
      });
    }
  };
  const hasPrivileges = definition.privileges.text_structure;
  const isAvailableForTier = core.pricing.isFeatureAvailable(_common.STREAMS_TIERED_ML_FEATURE.id);
  const areSuggestionsAvailable = hasPrivileges && isAvailableForTier;

  /**
   * When the component mounts, we want to apply suggestions if the field name is prepopulated
   * and the formats field is empty. This is to avoid overwriting user input.
   * We also check if the formats field is touched to avoid overwriting user input.
   */
  (0, _useMount.default)(() => {
    const {
      field,
      formats
    } = form.getValues();
    const isTouched = form.formState.touchedFields.formats;
    if (areSuggestionsAvailable && field && (0, _lodash.isEmpty)(formats) && !isTouched) {
      applySuggestions({
        field
      });
    }
  });

  /*
   * When the processor field changes, we want to apply suggestions if the formats field is not touched
   * and the formats field is empty. This is to avoid overwriting user input.
   * The function is intentionally created depending on privileges, so that in case of no privileges
   * the component does not try to call it.
   */
  const handleProcessorFieldChange = areSuggestionsAvailable ? event => {
    const field = event.target.value;
    const prevFormats = form.getValues('formats');
    const hasFormats = !(0, _lodash.isEmpty)(prevFormats);
    const isTouched = form.formState.touchedFields.formats;
    if (!hasFormats || !isTouched) {
      applySuggestions({
        field
      });
    }
  } : undefined;

  /**
   * When the user clicks the "Generate" button, we want to apply suggestions
   * regardless of whether the formats field is touched or not.
   * The function is intentionally created depending on privileges, so that in case of no privileges
   * the component does not render the regenerate button.
   */
  const handleGenerateSuggestionClick = areSuggestionsAvailable ? () => {
    const field = form.getValues('field');
    applySuggestions({
      field
    });
  } : undefined;
  return /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, /*#__PURE__*/_react.default.createElement(_processor_field_selector.ProcessorFieldSelector, {
    onChange: handleProcessorFieldChange
  }), /*#__PURE__*/_react.default.createElement(_date_formats_field.DateFormatsField, {
    onGenerate: handleGenerateSuggestionClick
  }), /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, {
    size: "m"
  }), /*#__PURE__*/_react.default.createElement(_optional_fields_accordion.FieldsAccordion, null, /*#__PURE__*/_react.default.createElement(_date_optional_fields.DateTargetField, null), /*#__PURE__*/_react.default.createElement(_date_optional_fields.DateTimezoneField, null), /*#__PURE__*/_react.default.createElement(_date_optional_fields.DateLocaleField, null), /*#__PURE__*/_react.default.createElement(_date_optional_fields.DateOutputFormatField, null), /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, {
    size: "m"
  }), /*#__PURE__*/_react.default.createElement(_processor_condition_editor.ProcessorConditionEditor, null)), /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, {
    size: "m"
  }), /*#__PURE__*/_react.default.createElement(_ignore_toggles.IgnoreFailureToggle, null));
};
exports.DateProcessorForm = DateProcessorForm;