"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.ConfigDrivenProcessorFields = void 0;
var _react = _interopRequireDefault(require("react"));
var _eui = require("@elastic/eui");
var _ = require("..");
var _processor_field_selector = require("../../processor_field_selector");
var _optional_fields_accordion = require("../../optional_fields_accordion");
var _ignore_toggles = require("../../ignore_toggles");
var _text_field = require("./text_field");
var _boolean_field = require("./boolean_field");
var _array_field = require("./array_field");
var _processor_condition_editor = require("../../processor_condition_editor");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const ConfigDrivenProcessorFields = ({
  type
}) => {
  const processor = _.configDrivenProcessors[type];

  // This shouldn't happen.
  if (!processor) {
    return null;
  }
  return /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, /*#__PURE__*/_react.default.createElement(_processor_field_selector.ProcessorFieldSelector, {
    helpText: processor.fieldOptions.fieldHelpText
  }), processor.fieldConfigurations.filter(fieldConfiguration => fieldConfiguration.required).map((fieldConfiguration, id) => /*#__PURE__*/_react.default.createElement(FieldComponentByConfig, {
    key: id,
    fieldConfiguration: fieldConfiguration
  })), /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, {
    size: "m"
  }), /*#__PURE__*/_react.default.createElement(_optional_fields_accordion.FieldsAccordion, null, processor.fieldConfigurations.filter(fieldConfiguration => !fieldConfiguration.required).map((fieldConfiguration, id) => /*#__PURE__*/_react.default.createElement(FieldComponentByConfig, {
    key: id,
    fieldConfiguration: fieldConfiguration
  })), processor.fieldOptions.includeCondition && /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, {
    size: "m"
  }), /*#__PURE__*/_react.default.createElement(_processor_condition_editor.ProcessorConditionEditor, null))), /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, {
    size: "m"
  }), processor.fieldOptions.includeIgnoreFailures && /*#__PURE__*/_react.default.createElement(_ignore_toggles.IgnoreFailureToggle, null), processor.fieldOptions.includeIgnoreMissing && /*#__PURE__*/_react.default.createElement(_ignore_toggles.IgnoreMissingToggle, null));
};
exports.ConfigDrivenProcessorFields = ConfigDrivenProcessorFields;
const FieldComponentByConfig = ({
  fieldConfiguration
}) => {
  switch (fieldConfiguration.type) {
    case 'string':
      return /*#__PURE__*/_react.default.createElement(_text_field.TextField, {
        fieldConfiguration: fieldConfiguration
      });
    case 'array':
      return /*#__PURE__*/_react.default.createElement(_array_field.ArrayField, {
        fieldConfiguration: fieldConfiguration
      });
    case 'boolean':
      return /*#__PURE__*/_react.default.createElement(_boolean_field.BooleanField, {
        fieldConfiguration: fieldConfiguration
      });
  }
};