"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.RandomSamplesDataSourceCard = void 0;
var _react = _interopRequireDefault(require("react"));
var _eui = require("@elastic/eui");
var _data_source_card = require("./data_source_card");
var _translations = require("./translations");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const RandomSamplesDataSourceCard = ({
  dataSourceRef
}) => {
  return /*#__PURE__*/_react.default.createElement(_data_source_card.DataSourceCard, {
    dataSourceRef: dataSourceRef,
    title: _translations.DATA_SOURCES_I18N.randomSamples.name,
    subtitle: _translations.DATA_SOURCES_I18N.randomSamples.subtitle
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiCallOut, {
    iconType: "info",
    size: "s",
    title: _translations.DATA_SOURCES_I18N.randomSamples.callout
  }), /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, {
    size: "m"
  }));
};
exports.RandomSamplesDataSourceCard = RandomSamplesDataSourceCard;