"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.AuthStep = void 0;
var _react = _interopRequireDefault(require("react"));
var _eui = require("@elastic/eui");
var _auth_config = require("../../../common/auth/auth_config");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const AuthStep = ({
  display,
  readOnly
}) => {
  return /*#__PURE__*/_react.default.createElement("span", {
    "data-test-subj": "authStep",
    style: {
      display: display ? 'block' : 'none'
    }
  }, /*#__PURE__*/_react.default.createElement(_auth_config.AuthConfig, {
    readOnly: readOnly
  }), /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, {
    size: "s"
  }));
};
exports.AuthStep = AuthStep;