"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.SearchSourceExpressionForm = void 0;
var _react = _interopRequireWildcard(require("react"));
var _fastDeepEqual = _interopRequireDefault(require("fast-deep-equal"));
var _rxjs = require("rxjs");
var _i18nReact = require("@kbn/i18n-react");
var _eui = require("@elastic/eui");
var _public = require("@kbn/data-plugin/public");
var _common = require("@kbn/triggers-actions-ui-plugin/public/common");
var _ruleDataUtils = require("@kbn/rule-data-utils");
var _common2 = require("../../../../common");
var _constants = require("../constants");
var _data_view_select_popover = require("../../components/data_view_select_popover");
var _rule_common_expressions = require("../rule_common_expressions");
var _util = require("../util");
var _validation = require("../validation");
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const HIDDEN_FILTER_PANEL_OPTIONS = ['pinFilter', 'disableFilter'];
const isSearchSourceParam = action => {
  return action.type === 'filter' || action.type === 'index' || action.type === 'query';
};
const SearchSourceExpressionForm = props => {
  var _ruleParams$threshold, _ruleParams$threshold2, _ruleParams$timeWindo, _ruleParams$timeWindo2, _ruleParams$aggType, _ruleParams$groupBy, _ruleParams$termSize, _ruleParams$size, _ruleParams$excludeHi;
  const services = (0, _util.useTriggerUiActionServices)();
  const unifiedSearch = services.unifiedSearch;
  const {
    dataViews,
    dataViewEditor,
    isServerless
  } = (0, _util.useTriggerUiActionServices)();
  const {
    searchSource,
    errors,
    initialSavedQuery,
    setParam,
    ruleParams
  } = props;
  const [savedQuery, setSavedQuery] = (0, _react.useState)();
  (0, _react.useEffect)(() => setSavedQuery(initialSavedQuery), [initialSavedQuery]);
  const [ruleConfiguration, dispatch] = (0, _react.useReducer)((currentState, action) => {
    if (isSearchSourceParam(action)) {
      searchSource.setParent(undefined).setField(action.type, action.payload);
      setParam('searchConfiguration', searchSource.getSerializedFields());
      if (action.type === 'index') {
        var _searchSource$getFiel;
        setParam('timeField', (_searchSource$getFiel = searchSource.getField('index')) === null || _searchSource$getFiel === void 0 ? void 0 : _searchSource$getFiel.timeFieldName);
      }
    } else {
      setParam(action.type, action.payload);
    }
    return {
      ...currentState,
      [action.type]: action.payload
    };
  }, {
    index: searchSource.getField('index'),
    query: searchSource.getField('query'),
    filter: (0, _public.mapAndFlattenFilters)(searchSource.getField('filter')),
    threshold: (_ruleParams$threshold = ruleParams.threshold) !== null && _ruleParams$threshold !== void 0 ? _ruleParams$threshold : _constants.DEFAULT_VALUES.THRESHOLD,
    thresholdComparator: (_ruleParams$threshold2 = ruleParams.thresholdComparator) !== null && _ruleParams$threshold2 !== void 0 ? _ruleParams$threshold2 : _constants.DEFAULT_VALUES.THRESHOLD_COMPARATOR,
    timeWindowSize: (_ruleParams$timeWindo = ruleParams.timeWindowSize) !== null && _ruleParams$timeWindo !== void 0 ? _ruleParams$timeWindo : _constants.DEFAULT_VALUES.TIME_WINDOW_SIZE,
    timeWindowUnit: (_ruleParams$timeWindo2 = ruleParams.timeWindowUnit) !== null && _ruleParams$timeWindo2 !== void 0 ? _ruleParams$timeWindo2 : _constants.DEFAULT_VALUES.TIME_WINDOW_UNIT,
    aggType: (_ruleParams$aggType = ruleParams.aggType) !== null && _ruleParams$aggType !== void 0 ? _ruleParams$aggType : _constants.DEFAULT_VALUES.AGGREGATION_TYPE,
    aggField: ruleParams.aggField,
    groupBy: (_ruleParams$groupBy = ruleParams.groupBy) !== null && _ruleParams$groupBy !== void 0 ? _ruleParams$groupBy : _constants.DEFAULT_VALUES.GROUP_BY,
    termSize: (_ruleParams$termSize = ruleParams.termSize) !== null && _ruleParams$termSize !== void 0 ? _ruleParams$termSize : _constants.DEFAULT_VALUES.TERM_SIZE,
    termField: ruleParams.termField,
    size: (_ruleParams$size = ruleParams.size) !== null && _ruleParams$size !== void 0 ? _ruleParams$size : isServerless ? _constants.SERVERLESS_DEFAULT_VALUES.SIZE : _constants.DEFAULT_VALUES.SIZE,
    excludeHitsFromPreviousRun: (_ruleParams$excludeHi = ruleParams.excludeHitsFromPreviousRun) !== null && _ruleParams$excludeHi !== void 0 ? _ruleParams$excludeHi : _constants.DEFAULT_VALUES.EXCLUDE_PREVIOUS_HITS,
    sourceFields: ruleParams.sourceFields
  });
  const {
    index: dataView,
    query,
    filter: filters
  } = ruleConfiguration;
  const indexPatterns = (0, _react.useMemo)(() => dataView ? [dataView] : [], [dataView]);
  const [esFields, setEsFields] = (0, _react.useState)(dataView ? (0, _util.convertFieldSpecToFieldOption)(dataView.fields.map(field => field.toSpec())) : []);
  const onSelectDataView = (0, _react.useCallback)(newDataView => {
    dispatch({
      type: 'index',
      payload: newDataView
    });
    dispatch({
      type: 'sourceFields',
      payload: undefined
    });
    setEsFields((0, _util.convertFieldSpecToFieldOption)(newDataView.fields.map(field => field.toSpec())));
  }, []);
  const onUpdateFilters = (0, _react.useCallback)(newFilters => {
    dispatch({
      type: 'filter',
      payload: (0, _public.mapAndFlattenFilters)(newFilters)
    });
  }, []);
  const onChangeQuery = (0, _react.useCallback)(({
    query: newQuery
  }) => {
    if (!(0, _fastDeepEqual.default)(newQuery, query)) {
      dispatch({
        type: 'query',
        payload: newQuery || {
          ...query,
          query: ''
        }
      });
    }
  }, [query]);

  // needs to change language mode only
  const onQueryBarSubmit = ({
    query: newQuery
  }) => {
    if ((newQuery === null || newQuery === void 0 ? void 0 : newQuery.language) !== query.language) {
      dispatch({
        type: 'query',
        payload: {
          ...query,
          language: newQuery === null || newQuery === void 0 ? void 0 : newQuery.language
        }
      });
    }
  };

  // Saved query
  const onSavedQuery = (0, _react.useCallback)(newSavedQuery => {
    setSavedQuery(newSavedQuery);
    const newFilters = newSavedQuery.attributes.filters;
    if (newFilters) {
      dispatch({
        type: 'filter',
        payload: newFilters
      });
    }
  }, []);
  const onClearSavedQuery = () => {
    setSavedQuery(undefined);
    dispatch({
      type: 'query',
      payload: {
        ...query,
        query: ''
      }
    });
  };

  // window size
  const onChangeWindowUnit = (0, _react.useCallback)(selectedWindowUnit => dispatch({
    type: 'timeWindowUnit',
    payload: selectedWindowUnit
  }), []);
  const onChangeWindowSize = (0, _react.useCallback)(selectedWindowSize => selectedWindowSize && dispatch({
    type: 'timeWindowSize',
    payload: selectedWindowSize
  }), []);

  // threshold
  const onChangeSelectedThresholdComparator = (0, _react.useCallback)(selectedThresholdComparator => selectedThresholdComparator && dispatch({
    type: 'thresholdComparator',
    payload: selectedThresholdComparator
  }), []);
  const onChangeSelectedAggField = (0, _react.useCallback)(selectedAggField => dispatch({
    type: 'aggField',
    payload: selectedAggField
  }), []);
  const onChangeSelectedAggType = (0, _react.useCallback)(selectedAggType => dispatch({
    type: 'aggType',
    payload: selectedAggType
  }), []);
  const onChangeSelectedGroupBy = (0, _react.useCallback)(selectedGroupBy => selectedGroupBy && dispatch({
    type: 'groupBy',
    payload: selectedGroupBy
  }), []);
  const onChangeSelectedTermField = (0, _react.useCallback)(selectedTermField => dispatch({
    type: 'termField',
    payload: selectedTermField
  }), []);
  const onChangeSelectedTermSize = (0, _react.useCallback)(selectedTermSize => selectedTermSize && dispatch({
    type: 'termSize',
    payload: selectedTermSize
  }), []);
  const onChangeSelectedThreshold = (0, _react.useCallback)(selectedThresholds => selectedThresholds && dispatch({
    type: 'threshold',
    payload: selectedThresholds
  }), []);
  const onChangeSizeValue = (0, _react.useCallback)(updatedValue => dispatch({
    type: 'size',
    payload: updatedValue
  }), []);
  const onChangeExcludeHitsFromPreviousRun = (0, _react.useCallback)(exclude => dispatch({
    type: 'excludeHitsFromPreviousRun',
    payload: exclude
  }), []);
  const onChangeSourceFields = (0, _react.useCallback)(selectedSourceFields => dispatch({
    type: 'sourceFields',
    payload: selectedSourceFields
  }), []);
  const timeWindow = `${ruleConfiguration.timeWindowSize}${ruleConfiguration.timeWindowUnit}`;
  const createTestSearchSource = (0, _react.useCallback)(() => {
    var _ruleParams$threshold3;
    const testSearchSource = searchSource.createCopy();
    const timeFilter = (0, _public.getTime)(searchSource.getField('index'), {
      from: `now-${timeWindow}`,
      to: 'now'
    });
    testSearchSource.setField('filter', timeFilter ? [timeFilter, ...ruleConfiguration.filter] : ruleConfiguration.filter);
    testSearchSource.setField('aggs', (0, _common.buildAggregation)({
      aggType: ruleParams.aggType,
      aggField: ruleParams.aggField,
      termField: ruleParams.termField,
      termSize: ruleParams.termSize,
      condition: {
        conditionScript: (0, _common2.getComparatorScript)((_ruleParams$threshold3 = ruleParams.thresholdComparator) !== null && _ruleParams$threshold3 !== void 0 ? _ruleParams$threshold3 : _constants.DEFAULT_VALUES.THRESHOLD_COMPARATOR, ruleParams.threshold, _common.BUCKET_SELECTOR_FIELD)
      }
    }));
    return testSearchSource;
  }, [searchSource, timeWindow, ruleConfiguration, ruleParams.aggType, ruleParams.aggField, ruleParams.termField, ruleParams.termSize, ruleParams.threshold, ruleParams.thresholdComparator]);
  const onCopyQuery = (0, _react.useCallback)(() => {
    const testSearchSource = createTestSearchSource();
    return JSON.stringify(testSearchSource.getSearchRequestBody(), null, 2);
  }, [createTestSearchSource]);
  const onTestFetch = (0, _react.useCallback)(async () => {
    const isGroupAgg = (0, _common.isGroupAggregation)(ruleParams.termField);
    const isCountAgg = (0, _common.isCountAggregation)(ruleParams.aggType);
    const testSearchSource = createTestSearchSource();
    const {
      rawResponse
    } = await (0, _rxjs.lastValueFrom)(testSearchSource.fetch$());
    return {
      testResults: (0, _common.parseAggregationResults)({
        isCountAgg,
        isGroupAgg,
        esResult: rawResponse
      }),
      isGrouped: isGroupAgg,
      timeWindow
    };
  }, [timeWindow, createTestSearchSource, ruleParams.aggType, ruleParams.termField]);
  return /*#__PURE__*/_react.default.createElement(_react.Fragment, null, /*#__PURE__*/_react.default.createElement(_eui.EuiFormRow, {
    fullWidth: true,
    label: /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
      id: "xpack.stackAlerts.esQuery.ui.selectDataViewPrompt",
      defaultMessage: "Select a data view"
    })
  }, /*#__PURE__*/_react.default.createElement(_data_view_select_popover.DataViewSelectPopover, {
    dependencies: {
      dataViews,
      dataViewEditor
    },
    dataView: dataView,
    metadata: props.metadata,
    onSelectDataView: onSelectDataView,
    onChangeMetaData: props.onChangeMetaData
  })), Boolean(dataView === null || dataView === void 0 ? void 0 : dataView.id) && /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, {
    size: "s"
  }), /*#__PURE__*/_react.default.createElement(_eui.EuiTitle, {
    size: "xs"
  }, /*#__PURE__*/_react.default.createElement("h5", null, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
    id: "xpack.stackAlerts.esQuery.ui.defineTextQueryPrompt",
    defaultMessage: "Define your query"
  }))), /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, {
    size: "xs"
  }), /*#__PURE__*/_react.default.createElement(unifiedSearch.ui.SearchBar, {
    appName: _ruleDataUtils.STACK_ALERTS_FEATURE_ID,
    onQuerySubmit: onQueryBarSubmit,
    onQueryChange: onChangeQuery,
    suggestionsSize: "s",
    displayStyle: "inPage",
    query: query,
    indexPatterns: indexPatterns,
    savedQuery: savedQuery,
    filters: filters,
    onFiltersUpdated: onUpdateFilters,
    onClearSavedQuery: onClearSavedQuery,
    onSavedQueryUpdated: onSavedQuery,
    onSaved: onSavedQuery,
    allowSavingQueries: true,
    showQueryInput: true,
    showFilterBar: true,
    showDatePicker: false,
    showAutoRefreshOnly: false,
    showSubmitButton: false,
    dateRangeFrom: undefined,
    dateRangeTo: undefined,
    hiddenFilterPanelOptions: HIDDEN_FILTER_PANEL_OPTIONS
  })), /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, {
    size: "m"
  }), /*#__PURE__*/_react.default.createElement(_rule_common_expressions.RuleCommonExpressions, {
    threshold: ruleConfiguration.threshold,
    thresholdComparator: ruleConfiguration.thresholdComparator,
    timeWindowSize: ruleConfiguration.timeWindowSize,
    timeWindowUnit: ruleConfiguration.timeWindowUnit,
    size: ruleConfiguration.size,
    esFields: esFields,
    aggType: ruleConfiguration.aggType,
    aggField: ruleConfiguration.aggField,
    groupBy: ruleConfiguration.groupBy,
    termSize: ruleConfiguration.termSize,
    termField: ruleConfiguration.termField,
    onChangeSelectedAggField: onChangeSelectedAggField,
    onChangeSelectedAggType: onChangeSelectedAggType,
    onChangeSelectedGroupBy: onChangeSelectedGroupBy,
    onChangeSelectedTermField: onChangeSelectedTermField,
    onChangeSelectedTermSize: onChangeSelectedTermSize,
    onChangeThreshold: onChangeSelectedThreshold,
    onChangeThresholdComparator: onChangeSelectedThresholdComparator,
    onChangeWindowSize: onChangeWindowSize,
    onChangeWindowUnit: onChangeWindowUnit,
    onChangeSizeValue: onChangeSizeValue,
    errors: errors,
    hasValidationErrors: (0, _validation.hasExpressionValidationErrors)(props.ruleParams, isServerless),
    onTestFetch: onTestFetch,
    onCopyQuery: onCopyQuery,
    excludeHitsFromPreviousRun: ruleConfiguration.excludeHitsFromPreviousRun,
    onChangeExcludeHitsFromPreviousRun: onChangeExcludeHitsFromPreviousRun,
    canSelectMultiTerms: _constants.DEFAULT_VALUES.CAN_SELECT_MULTI_TERMS,
    onChangeSourceFields: onChangeSourceFields,
    sourceFields: ruleConfiguration.sourceFields
  }), /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, null));
};
exports.SearchSourceExpressionForm = SearchSourceExpressionForm;