"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.ReservedSpaceBadge = void 0;
var _eui = require("@elastic/eui");
var _react = _interopRequireDefault(require("react"));
var _i18nReact = require("@kbn/i18n-react");
var _common = require("../../../common");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const ReservedSpaceBadge = props => {
  const {
    space
  } = props;
  if (space && (0, _common.isReservedSpace)(space)) {
    return /*#__PURE__*/_react.default.createElement(_eui.EuiToolTip, {
      content: /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
        id: "xpack.spaces.management.reversedSpaceBadge.reversedSpacesCanBePartiallyModifiedTooltip",
        defaultMessage: "Reserved spaces are built-in and can only be partially modified."
      })
    }, /*#__PURE__*/_react.default.createElement(_eui.EuiBadge, {
      tabIndex: 0,
      color: "warning",
      iconType: "question",
      iconSide: "right"
    }, "Reserved space"));
  }
  return null;
};
exports.ReservedSpaceBadge = ReservedSpaceBadge;