"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.registerSpacesEventTypes = registerSpacesEventTypes;
var _event_tracker = require("./event_tracker");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const fields = {
  [_event_tracker.FieldType.SPACE_ID]: {
    [_event_tracker.FieldType.SPACE_ID]: {
      type: 'keyword',
      _meta: {
        description: 'The ID of the space.'
      }
    }
  },
  [_event_tracker.FieldType.SPACE_ID_PREV]: {
    [_event_tracker.FieldType.SPACE_ID_PREV]: {
      type: 'keyword',
      _meta: {
        description: 'The previous ID of the space (before switching space).'
      }
    }
  },
  [_event_tracker.FieldType.SOLUTION]: {
    [_event_tracker.FieldType.SOLUTION]: {
      type: 'keyword',
      _meta: {
        description: 'The solution set for the space.'
      }
    }
  },
  [_event_tracker.FieldType.SOLUTION_PREV]: {
    [_event_tracker.FieldType.SOLUTION_PREV]: {
      type: 'keyword',
      _meta: {
        description: 'The previous solution value before editing the space.',
        optional: true
      }
    }
  },
  [_event_tracker.FieldType.ACTION]: {
    [_event_tracker.FieldType.ACTION]: {
      type: 'keyword',
      _meta: {
        description: 'The user action, either create or edit a space.'
      }
    }
  }
};
const eventTypes = [{
  eventType: _event_tracker.EventType.SPACE_SOLUTION_CHANGED,
  schema: {
    ...fields[_event_tracker.FieldType.SPACE_ID],
    ...fields[_event_tracker.FieldType.SOLUTION_PREV],
    ...fields[_event_tracker.FieldType.SOLUTION],
    ...fields[_event_tracker.FieldType.ACTION]
  }
}, {
  eventType: _event_tracker.EventType.SPACE_CHANGED,
  schema: {
    ...fields[_event_tracker.FieldType.SPACE_ID],
    ...fields[_event_tracker.FieldType.SPACE_ID_PREV],
    ...fields[_event_tracker.FieldType.SOLUTION_PREV],
    ...fields[_event_tracker.FieldType.SOLUTION]
  }
}];
function registerSpacesEventTypes(core) {
  const {
    analytics
  } = core;
  for (const eventType of eventTypes) {
    analytics.registerEventType(eventType);
  }
}