"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.RetentionExecuteModalProvider = void 0;
var _react = _interopRequireWildcard(require("react"));
var _i18nReact = require("@kbn/i18n-react");
var _eui = require("@elastic/eui");
var _app_context = require("../app_context");
var _http = require("../services/http");
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const RetentionExecuteModalProvider = ({
  children
}) => {
  const {
    i18n
  } = (0, _app_context.useServices)();
  const toastNotifications = (0, _app_context.useToastNotifications)();
  const [isModalOpen, setIsModalOpen] = (0, _react.useState)(false);
  const modalTitleId = (0, _eui.useGeneratedHtmlId)();
  const executeRetentionPrompt = () => {
    setIsModalOpen(true);
  };
  const closeModal = () => {
    setIsModalOpen(false);
  };
  const executeRetention = () => {
    (0, _http.executeRetention)().then(({
      error
    }) => {
      if (error) {
        const errorMessage = i18n.translate('xpack.snapshotRestore.executeRetention.errorMessage', {
          defaultMessage: 'Error running retention'
        });
        toastNotifications.addDanger(errorMessage);
      } else {
        const successMessage = i18n.translate('xpack.snapshotRestore.executeRetention.successMessage', {
          defaultMessage: 'Retention is running'
        });
        toastNotifications.addSuccess(successMessage);
      }
    });
    closeModal();
  };
  const renderModal = () => {
    if (!isModalOpen) {
      return null;
    }
    return /*#__PURE__*/_react.default.createElement(_eui.EuiConfirmModal, {
      "aria-labelledby": modalTitleId,
      titleProps: {
        id: modalTitleId
      },
      title: /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
        id: "xpack.snapshotRestore.executeRetention.confirmModal.executeRetentionTitle",
        defaultMessage: "Run snapshot retention now?"
      }),
      onCancel: closeModal,
      onConfirm: executeRetention,
      cancelButtonText: /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
        id: "xpack.snapshotRestore.executeRetention.confirmModal.cancelButtonLabel",
        defaultMessage: "Cancel"
      }),
      confirmButtonText: /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
        id: "xpack.snapshotRestore.executeRetention.confirmModal.confirmButtonLabel",
        defaultMessage: "Run retention"
      }),
      "data-test-subj": "executeRetentionModal"
    });
  };
  return /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, children(executeRetentionPrompt), renderModal());
};
exports.RetentionExecuteModalProvider = RetentionExecuteModalProvider;