"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.ReadonlySettings = void 0;
var _react = _interopRequireWildcard(require("react"));
var _i18nReact = require("@kbn/i18n-react");
var _eui = require("@elastic/eui");
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const ReadonlySettings = ({
  repository,
  updateRepositorySettings,
  settingErrors
}) => {
  const {
    settings: {
      url
    }
  } = repository;
  const hasErrors = Boolean(Object.keys(settingErrors).length);
  function getSchemeHelpText(scheme) {
    switch (scheme) {
      case 'http':
      case 'https':
      case 'ftp':
        return /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
          id: "xpack.snapshotRestore.repositoryForm.typeReadonly.urlAllowedDescription",
          defaultMessage: "This URL must be registered in the {settingKey} setting.",
          values: {
            settingKey: /*#__PURE__*/_react.default.createElement(_eui.EuiCode, null, "repositories.url.allowed_urls")
          }
        });
      case 'file':
        return /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
          id: "xpack.snapshotRestore.repositoryForm.typeReadonly.urlFilePathDescription",
          defaultMessage: "This file location must be registered in the {settingKey} setting.",
          values: {
            settingKey: /*#__PURE__*/_react.default.createElement(_eui.EuiCode, null, "path.repo")
          }
        });
      default:
        return null;
    }
  }
  const schemeOptions = [{
    value: 'http',
    text: 'http://'
  }, {
    value: 'https',
    text: 'https://'
  }, {
    value: 'ftp',
    text: 'ftp://'
  }, {
    value: 'file',
    text: 'file://'
  }];
  const [selectedScheme, selectScheme] = (0, _react.useState)(url ? url.split('://')[0] : 'http');
  return /*#__PURE__*/_react.default.createElement(_react.Fragment, null, /*#__PURE__*/_react.default.createElement(_eui.EuiDescribedFormGroup, {
    title: /*#__PURE__*/_react.default.createElement(_eui.EuiTitle, {
      size: "s"
    }, /*#__PURE__*/_react.default.createElement("h3", null, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
      id: "xpack.snapshotRestore.repositoryForm.typeReadonly.urlTitle",
      defaultMessage: "URL"
    }))),
    description: /*#__PURE__*/_react.default.createElement(_react.Fragment, null, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
      id: "xpack.snapshotRestore.repositoryForm.typeReadonly.urlDescription",
      defaultMessage: "The location of the snapshots."
    })),
    fullWidth: true
  }, /*#__PURE__*/_react.default.createElement("div", null, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
    gutterSize: "s"
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    grow: false
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFormRow, {
    label: /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
      id: "xpack.snapshotRestore.repositoryForm.typeReadonly.urlSchemeLabel",
      defaultMessage: "Scheme"
    }),
    fullWidth: true
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiSelect, {
    options: schemeOptions,
    value: selectedScheme,
    onChange: e => selectScheme(e.target.value),
    "aria-controls": "readonlyRepositoryUrlHelp",
    "data-test-subj": "schemeSelect"
  }))), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, null, /*#__PURE__*/_react.default.createElement(_eui.EuiFormRow, {
    label: /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
      id: "xpack.snapshotRestore.repositoryForm.typeReadonly.urlLabel",
      defaultMessage: "Path (required)"
    }),
    fullWidth: true,
    describedByIds: ['readonlyRepositoryUrlHelp'],
    isInvalid: Boolean(hasErrors && settingErrors.url),
    error: settingErrors.url
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFieldText, {
    isInvalid: Boolean(hasErrors && settingErrors.url),
    defaultValue: url ? url.split('://')[1] : '',
    fullWidth: true,
    onChange: e => {
      updateRepositorySettings({
        url: `${selectedScheme}://${e.target.value}`
      });
    },
    "data-test-subj": "urlInput"
  })))), /*#__PURE__*/_react.default.createElement(_eui.EuiFormHelpText, {
    id: "readonlyRepositoryUrlHelp",
    "aria-live": "polite"
  }, getSchemeHelpText(selectedScheme)))));
};
exports.ReadonlySettings = ReadonlySettings;