"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.createRemoteSloCloneUrl = createRemoteSloCloneUrl;
exports.createRemoteSloDeleteUrl = createRemoteSloDeleteUrl;
exports.createRemoteSloDetailsUrl = createRemoteSloDetailsUrl;
exports.createRemoteSloDisableUrl = createRemoteSloDisableUrl;
exports.createRemoteSloEditUrl = createRemoteSloEditUrl;
exports.createRemoteSloEnableUrl = createRemoteSloEnableUrl;
exports.createRemoteSloResetUrl = createRemoteSloResetUrl;
var _rison = require("@kbn/rison");
var _path = _interopRequireDefault(require("path"));
var _paths = require("../../../common/locators/paths");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

function createBaseRemoteSloDetailsUrl(slo, spaceId = 'default') {
  if (!slo.remote || slo.remote.kibanaUrl === '') {
    return undefined;
  }
  const spacePath = spaceId !== 'default' ? `/s/${spaceId}` : '';
  const detailsPath = _paths.paths.sloDetails(slo.id, slo.instanceId);
  const remoteUrl = new URL(_path.default.join(spacePath, detailsPath), slo.remote.kibanaUrl);
  return remoteUrl;
}
function createRemoteSloDetailsUrl(slo, spaceId = 'default') {
  var _createBaseRemoteSloD;
  return (_createBaseRemoteSloD = createBaseRemoteSloDetailsUrl(slo, spaceId)) === null || _createBaseRemoteSloD === void 0 ? void 0 : _createBaseRemoteSloD.toString();
}
function createRemoteSloDeleteUrl(slo, spaceId = 'default') {
  const remoteUrl = createBaseRemoteSloDetailsUrl(slo, spaceId);
  if (!remoteUrl) {
    return undefined;
  }
  remoteUrl.searchParams.append('delete', 'true');
  return remoteUrl.toString();
}
function createRemoteSloResetUrl(slo, spaceId = 'default') {
  const remoteUrl = createBaseRemoteSloDetailsUrl(slo, spaceId);
  if (!remoteUrl) {
    return undefined;
  }
  remoteUrl.searchParams.append('reset', 'true');
  return remoteUrl.toString();
}
function createRemoteSloEnableUrl(slo, spaceId = 'default') {
  const remoteUrl = createBaseRemoteSloDetailsUrl(slo, spaceId);
  if (!remoteUrl) {
    return undefined;
  }
  remoteUrl.searchParams.append('enable', 'true');
  return remoteUrl.toString();
}
function createRemoteSloDisableUrl(slo, spaceId = 'default') {
  const remoteUrl = createBaseRemoteSloDetailsUrl(slo, spaceId);
  if (!remoteUrl) {
    return undefined;
  }
  remoteUrl.searchParams.append('disable', 'true');
  return remoteUrl.toString();
}
function createRemoteSloEditUrl(slo, spaceId = 'default') {
  if (!slo.remote || slo.remote.kibanaUrl === '') {
    return undefined;
  }
  const spacePath = spaceId !== 'default' ? `/s/${spaceId}` : '';
  const editPath = _paths.paths.sloEdit(slo.id);
  const remoteUrl = new URL(_path.default.join(spacePath, editPath), slo.remote.kibanaUrl);
  return remoteUrl.toString();
}
function createRemoteSloCloneUrl(slo, spaceId = 'default') {
  if (!slo.remote || slo.remote.kibanaUrl === '') {
    return undefined;
  }
  const spacePath = spaceId !== 'default' ? `/s/${spaceId}` : '';
  const clonePath = _paths.paths.sloCreateWithEncodedForm((0, _rison.encode)({
    ...slo,
    name: `[Copy] ${slo.name}`,
    id: undefined
  }));
  const remoteUrl = new URL(_path.default.join(spacePath, clonePath), slo.remote.kibanaUrl);
  return remoteUrl.toString();
}