"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.MetricInput = MetricInput;
var _extends2 = _interopRequireDefault(require("@babel/runtime/helpers/extends"));
var _eui = require("@elastic/eui");
var _i18n = require("@kbn/i18n");
var _react = _interopRequireWildcard(require("react"));
var _reactHookForm = require("react-hook-form");
var _aggregation_options = require("../../../helpers/aggregation_options");
var _create_options = require("../../../helpers/create_options");
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const fieldLabel = _i18n.i18n.translate('xpack.slo.sloEdit.sliType.timesliceMetric.fieldLabel', {
  defaultMessage: 'Field'
});
const aggregationLabel = _i18n.i18n.translate('xpack.slo.sloEdit.sliType.timesliceMetric.aggregationLabel', {
  defaultMessage: 'Aggregation'
});
const fieldTooltip = /*#__PURE__*/_react.default.createElement(_eui.EuiIconTip, {
  content: _i18n.i18n.translate('xpack.slo.sloEdit.sliType.timesliceMetric.totalMetric.tooltip', {
    defaultMessage: 'This is the field used in the aggregation.'
  }),
  position: "top"
});
const NUMERIC_FIELD_TYPES = ['number', 'histogram'];
const CARDINALITY_FIELD_TYPES = ['number', 'string'];
function MetricInput({
  metricIndex: index,
  indexPattern,
  isLoadingIndex,
  indexFields
}) {
  const {
    control,
    watch
  } = (0, _reactHookForm.useFormContext)();
  const metric = watch(`indicator.params.metric.metrics.${index}`);
  const metricAggregation = watch(`indicator.params.metric.metrics.${index}.aggregation`);
  const [metricFields, setMetricFields] = (0, _react.useState)(indexFields.filter(field => NUMERIC_FIELD_TYPES.includes(field.type)));
  const [aggregationOptions, setAggregationOptions] = (0, _react.useState)(_aggregation_options.AGGREGATION_OPTIONS);
  const [fieldOptions, setFieldOptions] = (0, _react.useState)((0, _create_options.createOptionsFromFields)(metricFields));
  (0, _react.useEffect)(() => {
    setMetricFields(indexFields.filter(field => metricAggregation === 'cardinality' ? CARDINALITY_FIELD_TYPES.includes(field.type) : NUMERIC_FIELD_TYPES.includes(field.type)));
  }, [metricAggregation, setMetricFields, indexFields]);
  (0, _react.useEffect)(() => {
    setFieldOptions((0, _create_options.createOptionsFromFields)(metricFields));
  }, [metricFields, setFieldOptions]);
  return /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, null, /*#__PURE__*/_react.default.createElement(_reactHookForm.Controller, {
    name: `indicator.params.metric.metrics.${index}.aggregation`,
    defaultValue: "avg",
    rules: {
      required: true
    },
    control: control,
    render: ({
      field: {
        ref,
        ...field
      },
      fieldState
    }) => /*#__PURE__*/_react.default.createElement(_eui.EuiFormRow, {
      fullWidth: true,
      label: /*#__PURE__*/_react.default.createElement("span", null, aggregationLabel, " ", metric.name),
      isInvalid: fieldState.invalid
    }, /*#__PURE__*/_react.default.createElement(_eui.EuiComboBox, (0, _extends2.default)({}, field, {
      async: true,
      fullWidth: true,
      isClearable: false,
      singleSelection: {
        asPlainText: true
      },
      placeholder: _i18n.i18n.translate('xpack.slo.sloEdit.sliType.timesliceMetric.aggregationField.placeholder', {
        defaultMessage: 'Select an aggregation'
      }),
      "aria-label": _i18n.i18n.translate('xpack.slo.sloEdit.sliType.timesliceMetric.aggregationField.placeholder', {
        defaultMessage: 'Select an aggregation'
      }),
      isInvalid: fieldState.invalid,
      isDisabled: !indexPattern,
      isLoading: !!indexPattern && isLoadingIndex,
      onChange: selected => {
        if (selected.length) {
          return field.onChange(selected[0].value);
        }
        field.onChange('');
      },
      selectedOptions: !!indexPattern && !!field.value && _aggregation_options.AGGREGATION_OPTIONS.some(agg => agg.value === field.value) ? [{
        value: field.value,
        label: (0, _aggregation_options.aggValueToLabel)(field.value)
      }] : [],
      onSearchChange: searchValue => {
        setAggregationOptions(_aggregation_options.AGGREGATION_OPTIONS.filter(({
          value
        }) => value.includes(searchValue)));
      },
      options: aggregationOptions
    })))
  })), metricAggregation === 'percentile' && /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    grow: 0
  }, /*#__PURE__*/_react.default.createElement(_reactHookForm.Controller, {
    name: `indicator.params.metric.metrics.${index}.percentile`,
    defaultValue: 95,
    rules: {
      required: true,
      min: 0.001,
      max: 99.999
    },
    shouldUnregister: true,
    control: control,
    render: ({
      field: {
        ref,
        onChange,
        ...field
      },
      fieldState
    }) => /*#__PURE__*/_react.default.createElement(_eui.EuiFormRow, {
      fullWidth: true,
      isInvalid: fieldState.invalid,
      label: /*#__PURE__*/_react.default.createElement("span", null, _i18n.i18n.translate('xpack.slo.sloEdit.sliType.timesliceMetric.percentileLabel', {
        defaultMessage: 'Percentile'
      }), ' ', metric.name)
    }, /*#__PURE__*/_react.default.createElement(_eui.EuiFieldNumber, (0, _extends2.default)({}, field, {
      style: {
        width: 80
      },
      "data-test-subj": "timesliceMetricPercentileNumber",
      required: true,
      min: 0.1,
      max: 99.999,
      step: 0.1,
      value: field.value,
      isInvalid: fieldState.invalid,
      disabled: !indexPattern,
      isLoading: !!indexPattern && isLoadingIndex,
      onChange: event => onChange(Number(event.target.value))
    })))
  })), metricAggregation !== 'doc_count' && /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, null, /*#__PURE__*/_react.default.createElement(_reactHookForm.Controller, {
    name: `indicator.params.metric.metrics.${index}.field`,
    defaultValue: "",
    rules: {
      required: true
    },
    shouldUnregister: true,
    control: control,
    render: ({
      field: {
        ref,
        ...field
      },
      fieldState
    }) => /*#__PURE__*/_react.default.createElement(_eui.EuiFormRow, {
      fullWidth: true,
      isInvalid: fieldState.invalid,
      label: /*#__PURE__*/_react.default.createElement("span", null, fieldLabel, " ", metric.name, " ", fieldTooltip)
    }, /*#__PURE__*/_react.default.createElement(_eui.EuiComboBox, (0, _extends2.default)({}, field, {
      async: true,
      fullWidth: true,
      singleSelection: {
        asPlainText: true
      },
      placeholder: _i18n.i18n.translate('xpack.slo.sloEdit.sliType.timesliceMetric.metricField.placeholder', {
        defaultMessage: 'Select a metric field'
      }),
      "aria-label": _i18n.i18n.translate('xpack.slo.sloEdit.sliType.timesliceMetric.metricField.placeholder', {
        defaultMessage: 'Select a metric field'
      }),
      isInvalid: fieldState.invalid,
      isDisabled: !indexPattern,
      isLoading: !!indexPattern && isLoadingIndex,
      onChange: selected => {
        if (selected.length) {
          return field.onChange(selected[0].value);
        }
        field.onChange('');
      },
      selectedOptions: !!indexPattern && !!field.value && metricFields.some(metricField => metricField.name === field.value) ? [{
        value: field.value,
        label: field.value
      }] : [],
      onSearchChange: searchValue => {
        setFieldOptions((0, _create_options.createOptionsFromFields)(metricFields, ({
          value
        }) => value.includes(searchValue)));
      },
      options: fieldOptions
    })))
  })));
}