"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.CustomMetricIndicatorTypeForm = CustomMetricIndicatorTypeForm;
Object.defineProperty(exports, "NEW_CUSTOM_METRIC", {
  enumerable: true,
  get: function () {
    return _metric_indicator.NEW_CUSTOM_METRIC;
  }
});
var _eui = require("@elastic/eui");
var _i18n = require("@kbn/i18n");
var _i18nReact = require("@kbn/i18n-react");
var _react = _interopRequireDefault(require("react"));
var _reactHookForm = require("react-hook-form");
var _index_and_timestamp_field = require("../custom_common/index_and_timestamp_field");
var _group_by_field = require("../../common/group_by_field");
var _use_create_data_view = require("../../../../../hooks/use_create_data_view");
var _data_preview_chart = require("../../common/data_preview_chart");
var _query_builder = require("../../common/query_builder");
var _index_selection = require("../custom_common/index_selection");
var _metric_indicator = require("./metric_indicator");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const SUPPORTED_METRIC_FIELD_TYPES = ['number', 'histogram'];
function CustomMetricIndicatorTypeForm() {
  const {
    watch
  } = (0, _reactHookForm.useFormContext)();
  const index = watch('indicator.params.index');
  const dataViewId = watch(_index_selection.DATA_VIEW_FIELD);
  const {
    dataView,
    loading: isIndexFieldsLoading
  } = (0, _use_create_data_view.useCreateDataView)({
    indexPatternString: index,
    dataViewId
  });
  const metricFields = dataView === null || dataView === void 0 ? void 0 : dataView.fields.filter(field => SUPPORTED_METRIC_FIELD_TYPES.includes(field.type));
  return /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, /*#__PURE__*/_react.default.createElement(_eui.EuiTitle, {
    size: "xs"
  }, /*#__PURE__*/_react.default.createElement("h3", null, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
    id: "xpack.slo.sloEdit.sliType.histogram.sourceTitle",
    defaultMessage: "Source"
  }))), /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, {
    size: "s"
  }), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
    direction: "column",
    gutterSize: "m"
  }, /*#__PURE__*/_react.default.createElement(_index_and_timestamp_field.IndexAndTimestampField, {
    dataView: dataView,
    isLoading: isIndexFieldsLoading
  }), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, null, /*#__PURE__*/_react.default.createElement(_query_builder.QueryBuilder, {
    dataTestSubj: "customMetricIndicatorFormQueryFilterInput",
    dataView: dataView,
    label: _i18n.i18n.translate('xpack.slo.sloEdit.sliType.customMetric.queryFilter', {
      defaultMessage: 'Query filter'
    }),
    name: "indicator.params.filter",
    placeholder: _i18n.i18n.translate('xpack.slo.sloEdit.sliType.customMetric.customFilter', {
      defaultMessage: 'Custom filter to apply on the index'
    }),
    tooltip: /*#__PURE__*/_react.default.createElement(_eui.EuiIconTip, {
      content: _i18n.i18n.translate('xpack.slo.sloEdit.sliType.customMetric.customFilter.tooltip', {
        defaultMessage: 'This KQL query can be used to filter the documents with some relevant criteria.'
      }),
      position: "top"
    })
  })), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, null, /*#__PURE__*/_react.default.createElement(_eui.EuiHorizontalRule, {
    margin: "none"
  })), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, null, /*#__PURE__*/_react.default.createElement(_eui.EuiTitle, {
    size: "xs"
  }, /*#__PURE__*/_react.default.createElement("h3", null, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
    id: "xpack.slo.sloEdit.sliType.customMetric.goodTitle",
    defaultMessage: "Good events"
  }))), /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, {
    size: "s"
  }), /*#__PURE__*/_react.default.createElement(_metric_indicator.MetricIndicator, {
    type: "good",
    metricFields: metricFields !== null && metricFields !== void 0 ? metricFields : [],
    isLoadingIndex: isIndexFieldsLoading,
    dataView: dataView
  })), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, null, /*#__PURE__*/_react.default.createElement(_eui.EuiHorizontalRule, {
    margin: "none"
  })), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, null, /*#__PURE__*/_react.default.createElement(_eui.EuiTitle, {
    size: "xs"
  }, /*#__PURE__*/_react.default.createElement("h3", null, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
    id: "xpack.slo.sloEdit.sliType.customMetric.totalTitle",
    defaultMessage: "Total events"
  }))), /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, {
    size: "s"
  }), /*#__PURE__*/_react.default.createElement(_metric_indicator.MetricIndicator, {
    type: "total",
    metricFields: metricFields !== null && metricFields !== void 0 ? metricFields : [],
    isLoadingIndex: isIndexFieldsLoading,
    dataView: dataView
  })), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, null, /*#__PURE__*/_react.default.createElement(_eui.EuiHorizontalRule, {
    margin: "none"
  })), /*#__PURE__*/_react.default.createElement(_group_by_field.GroupByField, {
    dataView: dataView,
    isLoading: isIndexFieldsLoading
  }), /*#__PURE__*/_react.default.createElement(_data_preview_chart.DataPreviewChart, null)));
}