"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.useCreateDataView = useCreateDataView;
var _public = require("@kbn/observability-shared-plugin/public");
var _use_kibana = require("./use_kibana");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

function useCreateDataView({
  indexPatternString,
  dataViewId
}) {
  const {
    dataViews
  } = (0, _use_kibana.useKibana)().services;
  const {
    data: dataView,
    loading
  } = (0, _public.useFetcher)(async () => {
    if (dataViewId) {
      try {
        return await dataViews.get(dataViewId);
      } catch (e) {
        return dataViews.create({
          id: `${indexPatternString}-id`,
          title: indexPatternString,
          allowNoIndex: true
        });
      }
    } else if (indexPatternString) {
      return dataViews.create({
        id: `${indexPatternString}-id`,
        title: indexPatternString,
        allowNoIndex: true
      });
    }
  }, [dataViewId, dataViews, indexPatternString]);
  return {
    dataView,
    loading: Boolean(loading)
  };
}