"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.SimpleBurnRate = SimpleBurnRate;
var _eui = require("@elastic/eui");
var _numeral = _interopRequireDefault(require("@elastic/numeral"));
var _i18n = require("@kbn/i18n");
var _moment = _interopRequireDefault(require("moment"));
var _react = _interopRequireDefault(require("react"));
var _use_fetch_slo_burn_rates = require("../../../hooks/use_fetch_slo_burn_rates");
var _duration = require("../../../utils/slo/duration");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

function SimpleBurnRate({
  slo,
  duration,
  lastRefreshTime
}) {
  const [refreshTime, setRefreshTime] = _react.default.useState(lastRefreshTime);
  const {
    isLoading,
    data,
    refetch
  } = (0, _use_fetch_slo_burn_rates.useFetchSloBurnRates)({
    slo,
    windows: [{
      name: 'burn_rate',
      duration
    }]
  });
  _react.default.useEffect(() => {
    if (lastRefreshTime !== refreshTime) {
      setRefreshTime(lastRefreshTime);
      refetch();
    }
  }, [refreshTime, lastRefreshTime, refetch]);
  const durationLabel = _i18n.i18n.translate('xpack.slo.burnRate.durationLabel', {
    defaultMessage: 'Last {duration}',
    values: {
      duration
    }
  });
  if (isLoading || data === undefined) {
    return /*#__PURE__*/_react.default.createElement(_eui.EuiStat, {
      title: /*#__PURE__*/_react.default.createElement(_eui.EuiLoadingChart, null),
      textAlign: "left",
      isLoading: isLoading,
      titleColor: 'subdued',
      description: /*#__PURE__*/_react.default.createElement(_eui.EuiTextColor, {
        color: "subdued"
      }, /*#__PURE__*/_react.default.createElement("span", null, /*#__PURE__*/_react.default.createElement(_eui.EuiIcon, {
        type: "clock",
        color: 'subdued'
      }), " ", durationLabel))
    });
  }
  const burnRate = data.burnRates[0];
  const color = burnRate.burnRate > 1 ? 'danger' : 'success';
  const timeToExhaustLabel = _i18n.i18n.translate('xpack.slo.burnRate.exhaustionTimeLabel', {
    defaultMessage: 'At this rate, the entire error budget will be exhausted in {hour} hours.',
    values: {
      hour: (0, _numeral.default)(_moment.default.duration((0, _duration.toMinutes)((0, _duration.toDuration)(slo.timeWindow.duration)) / burnRate.burnRate, 'minutes').asHours()).format('0')
    }
  });
  return /*#__PURE__*/_react.default.createElement(_eui.EuiStat, {
    title: _i18n.i18n.translate('xpack.slo.burnRates.value', {
      defaultMessage: '{value}x',
      values: {
        value: (0, _numeral.default)(burnRate.burnRate).format('0.00')
      }
    }),
    textAlign: "left",
    isLoading: isLoading,
    titleColor: color,
    description: burnRate.burnRate > 1 ? /*#__PURE__*/_react.default.createElement(_eui.EuiToolTip, {
      position: "top",
      content: timeToExhaustLabel
    }, /*#__PURE__*/_react.default.createElement(_eui.EuiTextColor, {
      color: color
    }, /*#__PURE__*/_react.default.createElement("span", null, /*#__PURE__*/_react.default.createElement(_eui.EuiIcon, {
      type: "clock",
      color: color
    }), " ", durationLabel))) : /*#__PURE__*/_react.default.createElement(_eui.EuiTextColor, {
      color: color
    }, /*#__PURE__*/_react.default.createElement("span", null, /*#__PURE__*/_react.default.createElement(_eui.EuiIcon, {
      type: "clock",
      color: color
    }), " ", durationLabel))
  });
}